/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import uk.org.ogsadai.client.dbcreate.CreateTestDB;
import uk.org.ogsadai.client.dbcreate.CreateTestDatabaseException;

public class CreateTestSQLServerDB
extends CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";

    public CreateTestSQLServerDB(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        CreateTestSQLServerDB creator = new CreateTestSQLServerDB(args);
    }

    protected void setDefaultSettings() {
        this.mDBMS = "SQLServer";
        this.mDriver = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        this.mHost = "localhost";
        this.mPort = "1433";
        this.mDatabase = "ogsadai";
        this.mUsername = "ogsadai";
        this.mPassword = "ogsadai";
        this.mTable = "littleblackbook";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populateDatabase() throws CreateTestDatabaseException {
        this.loadDriver();
        Connection connection = null;
        try {
            try {
                String connectionURL = "jdbc:microsoft:sqlserver://" + this.mHost + ":" + this.mPort + ";DatabaseName=" + this.mDatabase;
                System.out.println("Opening connection to: " + connectionURL);
                connection = DriverManager.getConnection(connectionURL, this.mUsername, this.mPassword);
                String sDropTableStatement = "if exists (select table_name from information_schema.tables where table_name = '" + this.mTable + "') drop table " + this.mTable;
                System.out.println("Deleting " + this.mTable + " with statement: " + sDropTableStatement);
                Statement dropTableStatement = connection.createStatement();
                dropTableStatement.execute(sDropTableStatement);
                System.out.println("Creating " + this.mTable + " table in database");
                Statement createTableStatement = connection.createStatement();
                createTableStatement.execute("CREATE TABLE " + this.mTable + " (id INTEGER, name VARCHAR(64), " + "address VARCHAR(128), phone VARCHAR(20))");
                System.out.println("Preparing insert statement");
                PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO " + this.mTable + " (id, name, address, phone) " + "VALUES (?, ?, ?, ?)");
                System.out.println("Adding " + this.mNumberOfEntries + " entries to '" + this.mTable + "'...");
                for (int i = 1; i <= this.mNumberOfEntries; ++i) {
                    insertStatement.setString(1, Integer.toString(i));
                    insertStatement.setString(2, this.mData.generateName(i));
                    insertStatement.setString(3, this.mData.generateAddress());
                    insertStatement.setString(4, this.mData.generatePhone());
                    insertStatement.execute();
                }
                Object var9_9 = null;
                if (connection == null) return;
            }
            catch (SQLException e) {
                throw new CreateTestDatabaseException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        connection.close();
        return;
    }
}

