/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import uk.org.ogsadai.client.dbcreate.CreateTestDB;
import uk.org.ogsadai.client.dbcreate.CreateTestDatabaseException;

public class CreateTestPostgreSQLDB
extends CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    private boolean mDrop;
    private String mConnectionUrl;

    public CreateTestPostgreSQLDB(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        new CreateTestPostgreSQLDB(args);
    }

    protected void setDefaultSettings() {
        this.mDBMS = "PostgreSQL";
        this.mDriver = "org.postgresql.Driver";
        this.mHost = "localhost";
        this.mDatabase = "ogsadai";
        this.mUsername = "ogsadai";
        this.mPassword = "ogsadai";
        this.mTable = "littleblackbook";
        this.mPort = "5432";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populateDatabase() throws CreateTestDatabaseException {
        this.loadDriver();
        Connection connection = null;
        try {
            try {
                System.out.println("Opening connection to PostgreSQL database");
                String connectionUrl = this.mConnectionUrl;
                if (connectionUrl == null) {
                    connectionUrl = "jdbc:postgresql://" + this.mHost + ":" + this.mPort + "/" + this.mDatabase;
                }
                connection = DriverManager.getConnection(connectionUrl, this.mUsername, this.mPassword);
                Statement checkTableStatement = connection.createStatement();
                ResultSet rs = checkTableStatement.executeQuery("SELECT COUNT(*) FROM pg_class WHERE relname='" + this.mTable + "'");
                boolean tableExists = false;
                if (rs.next() && Integer.parseInt(rs.getString(1)) == 1) {
                    tableExists = true;
                }
                if (tableExists) {
                    System.out.println("Deleting " + this.mTable + " table in database");
                    Statement dropTableStatement = connection.createStatement();
                    dropTableStatement.execute("DROP TABLE " + this.mTable);
                }
                if (!this.mDrop) {
                    System.out.println("Creating '" + this.mTable + "' table in database");
                    Statement createTableStatement = connection.createStatement();
                    createTableStatement.execute("CREATE TABLE " + this.mTable + " (id INTEGER, name VARCHAR(64), " + "address VARCHAR(128), phone VARCHAR(20))");
                    System.out.println("Preparing insert statement");
                    PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO " + this.mTable + " (id, name, address, phone) VALUES (?, ?, ?, ?)");
                    System.out.println("Adding " + this.mNumberOfEntries + " entries to '" + this.mTable + "'...");
                    for (int i = 1; i <= this.mNumberOfEntries; ++i) {
                        String name = this.mData.generateName(i);
                        String address = this.mData.generateAddress();
                        String phone = this.mData.generatePhone();
                        insertStatement.setInt(1, i);
                        insertStatement.setString(2, name);
                        insertStatement.setString(3, address);
                        insertStatement.setString(4, phone);
                        insertStatement.execute();
                    }
                }
                Object var13_13 = null;
                if (connection == null) return;
            }
            catch (SQLException e) {
                throw new CreateTestDatabaseException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        connection.close();
        return;
    }

    protected boolean setupArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].toLowerCase().equals("-driverclass")) {
                this.mDriver = args[++i];
                continue;
            }
            if (args[i].toLowerCase().equals("-host")) {
                this.mHost = args[++i];
                continue;
            }
            if (args[i].toLowerCase().equals("-port")) {
                this.mPort = args[++i];
                continue;
            }
            if (args[i].toLowerCase().equals("-database")) {
                this.mDatabase = args[++i];
                continue;
            }
            if (args[i].toLowerCase().equals("-username")) {
                this.mUsername = args[++i];
                continue;
            }
            if (args[i].toLowerCase().equals("-password")) {
                this.mPassword = args[++i];
                continue;
            }
            if (args[i].toLowerCase().equals("-tablename")) {
                this.mTable = args[++i];
                continue;
            }
            if (args[i].toLowerCase().equals("-rows")) {
                this.mNumberOfEntries = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].toLowerCase().equals("-connectionurl")) {
                this.mConnectionUrl = args[++i];
                continue;
            }
            if (args[i].toLowerCase().equals("-drop")) {
                this.mDrop = true;
                continue;
            }
            return false;
        }
        return true;
    }

    protected void printVariables(String prefix) {
        System.out.println(prefix + " Settings:" + "\n\t" + this.mDBMS + "DriverClass:    \t" + this.mDriver);
        if (this.mConnectionUrl == null) {
            System.out.println("\t" + this.mDBMS + "HostName:       \t" + this.mHost + "\n\t" + this.mDBMS + "PortNumber:     \t" + this.mPort + "\n\t" + this.mDBMS + "DatabaseName:   \t" + this.mDatabase);
        } else {
            System.out.println("\t" + this.mDBMS + "ConnectionURL   \t" + this.mConnectionUrl);
        }
        System.out.println("\t" + this.mDBMS + "UserName:       \t" + this.mUsername + "\n\t" + this.mDBMS + "Password:       \t" + this.mPassword);
        if (!this.mDrop) {
            System.out.println("\tNameOfTableToCreate: \t" + this.mTable + "\n\tNumberOfRowsToCreate:\t" + this.mNumberOfEntries);
        } else {
            System.out.println("\tNameOfTableToDrop: \t" + this.mTable);
        }
    }

    protected void printUsage() {
        super.printUsage();
        System.out.println("\n\t\t[-connectionUrl " + this.mDBMS + "ConnectionURL]" + "\n\t\t[-drop]");
    }
}

