/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import uk.org.ogsadai.client.dbcreate.CreateTestDB;
import uk.org.ogsadai.client.dbcreate.CreateTestDatabaseException;

public class CreateTestMySQLDB
extends CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    private String mRootUsername;
    private String mRootPassword;

    public CreateTestMySQLDB(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        CreateTestMySQLDB creator = new CreateTestMySQLDB(args);
    }

    protected void setDefaultSettings() {
        this.mDBMS = "MySQL";
        this.mDriver = "org.gjt.mm.mysql.Driver";
        this.mHost = "localhost";
        this.mPort = "3306";
        this.mDatabase = "ogsadai";
        this.mUsername = "ogsadai";
        this.mPassword = "ogsadai";
        this.mTable = "littleblackbook";
        this.mRootUsername = "root";
        this.mRootPassword = "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populateDatabase() throws CreateTestDatabaseException {
        this.loadDriver();
        Connection connection = null;
        try {
            try {
                try {
                    System.out.println("Opening connection to MySQL system database");
                    Connection systemConnection = DriverManager.getConnection("jdbc:mysql://" + this.mHost + ":" + this.mPort + "/mysql?user=" + this.mRootUsername + "&password=" + this.mRootPassword);
                    System.out.println("Creating '" + this.mDatabase + "' database in MySQL if it does not already exist");
                    Statement createDatabaseStatement = systemConnection.createStatement();
                    createDatabaseStatement.execute("CREATE DATABASE IF NOT EXISTS " + this.mDatabase);
                    System.out.println("Creating user '" + this.mUsername + "' with password '" + this.mPassword + "' in MySQL if it does not already exist");
                    boolean userExists = false;
                    Statement createUserStatement = systemConnection.createStatement();
                    ResultSet rs = createDatabaseStatement.executeQuery("SELECT COUNT(user) FROM user WHERE user='" + this.mUsername + "'");
                    if (rs.next() && rs.getInt(1) > 0) {
                        userExists = true;
                    }
                    if (userExists) {
                        System.out.println("User '" + this.mUsername + "' already exists within MySQL");
                    } else {
                        createDatabaseStatement.execute("INSERT INTO user (host,user,password) VALUES ('localhost','" + this.mUsername + "',password('" + this.mPassword + "'))");
                        createDatabaseStatement.execute("INSERT INTO user (host,user,password) VALUES ('%','" + this.mUsername + "',password('" + this.mPassword + "'))");
                        createDatabaseStatement.execute("INSERT INTO user (host,user,password) VALUES ('localhost.localdomain','" + this.mUsername + "',password('" + this.mPassword + "'))");
                        createDatabaseStatement.execute("INSERT INTO db (host,db,user,select_priv,insert_priv,update_priv,delete_priv,create_priv,drop_priv) VALUES ('%','" + this.mDatabase + "','" + this.mUsername + "','Y','Y','Y','Y','Y','Y')");
                        createDatabaseStatement.execute("INSERT INTO db (host,db,user,select_priv,insert_priv,update_priv,delete_priv,create_priv,drop_priv) VALUES ('localhost','" + this.mDatabase + "','" + this.mUsername + "','Y','Y','Y','Y','Y','Y')");
                        createDatabaseStatement.execute("FLUSH PRIVILEGES");
                    }
                    systemConnection.close();
                }
                catch (Exception e) {
                    System.out.println("Error occured whilst attempting to create " + this.mDatabase + " database and user " + this.mUsername + " in MySQL.");
                    System.out.println("Error was: " + e.getLocalizedMessage());
                    System.out.println("Continuing to try to create " + this.mTable + " table on " + this.mDatabase + " database");
                }
                System.out.println("Opening connection to MySQL '" + this.mDatabase + "' database");
                connection = DriverManager.getConnection("jdbc:mysql://" + this.mHost + ":" + this.mPort + "/" + this.mDatabase + "?user=" + this.mUsername + "&password=" + this.mPassword);
                System.out.println("Deleting " + this.mTable + " table in database");
                Statement dropTableStatement = connection.createStatement();
                dropTableStatement.execute("DROP TABLE IF EXISTS " + this.mTable);
                System.out.println("Creating " + this.mTable + " table in database");
                Statement createTableStatement = connection.createStatement();
                createTableStatement.execute("CREATE TABLE IF NOT EXISTS " + this.mTable + " (id INTEGER, " + "name VARCHAR(64), " + "address VARCHAR(128), " + "phone VARCHAR(20))");
                System.out.println("Preparing insert statement");
                PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO " + this.mTable + " (id, name, address, phone) VALUES (?, ?, ?, ?)");
                System.out.println("Adding " + this.mNumberOfEntries + " entries to '" + this.mTable + "'...");
                for (int i = 1; i <= this.mNumberOfEntries; ++i) {
                    insertStatement.setString(1, Integer.toString(i));
                    insertStatement.setString(2, this.mData.generateName(i));
                    insertStatement.setString(3, this.mData.generateAddress());
                    insertStatement.setString(4, this.mData.generatePhone());
                    insertStatement.execute();
                }
                Object var8_11 = null;
                if (connection == null) return;
            }
            catch (SQLException e) {
                throw new CreateTestDatabaseException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        connection.close();
        return;
    }

    protected boolean setupArguments(String[] args) {
        if (args.length % 2 == 1) {
            return false;
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].toLowerCase().equals("-driverclass")) {
                this.mDriver = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-host")) {
                this.mHost = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-port")) {
                this.mPort = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-database")) {
                this.mDatabase = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-username")) {
                this.mUsername = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-password")) {
                this.mPassword = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-tablename")) {
                this.mTable = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-rows")) {
                this.mNumberOfEntries = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].toLowerCase().equals("-rootusername")) {
                this.mRootUsername = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-rootpassword")) {
                this.mRootPassword = args[i + 1];
                continue;
            }
            return false;
        }
        return true;
    }

    protected void printVariables(String prefix) {
        super.printVariables(prefix);
        System.out.println("\tMySQLRootUserName:   \t" + this.mRootUsername + "\n\tMySQLRootPassword:   \t" + this.mRootPassword);
    }

    protected void printUsage() {
        super.printUsage();
        System.out.println("\t\t[-rootusername MySQLRootUserName] [-rootpassword MySQLRootPassword]");
    }
}

