/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import uk.org.ogsadai.client.dbcreate.CreateTestDB;
import uk.org.ogsadai.client.dbcreate.CreateTestDatabaseException;

public class CreateTestDerbyDB
extends CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";

    public CreateTestDerbyDB(String[] args) {
        super(args);
    }

    protected void setDefaultSettings() {
        this.mDBMS = "derby";
        this.mTable = "littleblackbook";
        this.mDriver = "org.apache.derby.jdbc.EmbeddedDriver";
        this.mDatabase = "C:/Downloads/Derby/ogsadai";
        this.mUsername = "ogsadai";
        this.mPassword = "ogsadai";
    }

    protected boolean setupArguments(String[] args) {
        if (args.length % 2 == 1) {
            return false;
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].toLowerCase().equals("-driverclass")) {
                this.mDriver = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-database")) {
                this.mDatabase = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-username")) {
                this.mUsername = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-password")) {
                this.mPassword = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-tablename")) {
                this.mTable = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-rows")) {
                this.mNumberOfEntries = Integer.parseInt(args[i + 1]);
                continue;
            }
            return false;
        }
        return true;
    }

    protected void printUsage() {
        System.out.println("Usage:\njava uk.org.ogsadai.client.dbcreate.CreateTest" + this.mDBMS + "DB " + "[-driverclass " + this.mDBMS + "DriverClass] \n\t\t" + "[-database " + this.mDBMS + "DatabasePath] \n\t\t" + "[-username " + this.mDBMS + "UserName] " + "[-password " + this.mDBMS + "Password] \n\t\t" + "[-tablename NameOfTableToCreate] " + "[-rows NumberOfRowsToCreate]");
    }

    protected void printVariables(String prefix) {
        System.out.println(prefix + " Settings:" + "\n\t" + this.mDBMS + "DriverClass:    \t" + this.mDriver + "\n\t" + this.mDBMS + "DatabasePath:   \t" + this.mDatabase + "\n\t" + this.mDBMS + "UserName:       \t" + this.mUsername + "\n\t" + this.mDBMS + "Password:       \t" + this.mPassword + "\n\tNameOfTableToCreate: \t" + this.mTable + "\n\tNumberOfRowsToCreate:\t" + this.mNumberOfEntries);
    }

    public static void main(String[] args) {
        CreateTestDerbyDB creator = new CreateTestDerbyDB(args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populateDatabase() throws CreateTestDatabaseException {
        Connection connection = null;
        try {
            try {
                this.loadDriver();
                System.out.println("Opening connection to Derby database");
                connection = DriverManager.getConnection("jdbc:derby:" + this.mDatabase + ";create = true", this.mUsername, this.mPassword);
                boolean tableExist = false;
                Statement createTableStatement = connection.createStatement();
                ResultSet rs = createTableStatement.executeQuery("select count(*) from SYS.SYSTABLES where tablename = '" + this.mTable.toUpperCase() + "'");
                if (rs.next()) {
                    System.out.println("tab exists " + Integer.parseInt(rs.getString(1)));
                    if (Integer.parseInt(rs.getString(1)) == 1) {
                        tableExist = true;
                    }
                }
                if (tableExist) {
                    System.in.skip(System.in.available());
                    System.out.println("Table " + this.mTable + " exists already in " + this.mDBMS + " database " + this.mDatabase + "; continue? (press enter or terminate) ");
                    System.in.read();
                    System.out.println("Deleting " + this.mTable + " table in database");
                    Statement dropTableStatement = connection.createStatement();
                    dropTableStatement.execute("DROP TABLE " + this.mTable);
                }
                System.out.println("Creating " + this.mTable + " table in database");
                createTableStatement.execute("CREATE TABLE " + this.mTable + " (id INTEGER, name VARCHAR(64), address VARCHAR(128), phone VARCHAR(20))");
                System.out.println("Preparing insert statement");
                PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO " + this.mTable + " (id, name, address, phone) VALUES (?, ?, ?, ?)");
                System.out.println("Adding " + this.mNumberOfEntries + " entries to '" + this.mTable + "'...");
                for (int i = 1; i <= this.mNumberOfEntries; ++i) {
                    insertStatement.setString(1, Integer.toString(i));
                    insertStatement.setString(2, this.mData.generateName(i));
                    insertStatement.setString(3, this.mData.generateAddress());
                    insertStatement.setString(4, this.mData.generatePhone());
                    insertStatement.execute();
                }
                connection.close();
                System.out.println("Done!");
            }
            catch (Exception e) {
                throw new CreateTestDatabaseException(e);
            }
            Object var8_8 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        connection.close();
        return;
    }
}

