/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import uk.org.ogsadai.client.dbcreate.CreateTestDB;
import uk.org.ogsadai.client.dbcreate.CreateTestDatabaseException;

public class CreateTestDB2DB
extends CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";

    public CreateTestDB2DB(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        CreateTestDB2DB creator = new CreateTestDB2DB(args);
    }

    protected void setDefaultSettings() {
        this.mDBMS = "DB2";
        this.mTable = "littleblackbook";
        this.mDriver = "com.ibm.db2.jcc.DB2Driver";
        this.mHost = "localhost";
        this.mPort = "50000";
        this.mDatabase = "ogsadai";
        this.mUsername = "ogsadai";
        this.mPassword = "ogsadai";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populateDatabase() throws CreateTestDatabaseException {
        this.loadDriver();
        Connection connection = null;
        try {
            try {
                System.out.println("Opening connection to DB2 database");
                String url = "jdbc:db2://" + this.mHost + ":" + this.mPort + "/" + this.mDatabase;
                connection = DriverManager.getConnection(url, this.mUsername, this.mPassword);
                Statement createTableStatement = connection.createStatement();
                ResultSet rs = createTableStatement.executeQuery("select count(*) from syscat.tables where tabname='" + this.mTable.toUpperCase() + "' and type='T'");
                boolean tableExist = false;
                if (rs.next() && Integer.parseInt(rs.getString(1)) == 1) {
                    tableExist = true;
                }
                if (tableExist) {
                    System.out.println("Deleting " + this.mTable + " table in database");
                    Statement dropTableStatement = connection.createStatement();
                    dropTableStatement.execute("DROP TABLE " + this.mTable);
                }
                System.out.println("Creating " + this.mTable + " table in database");
                createTableStatement.execute("CREATE TABLE " + this.mTable + " (id INTEGER, name VARCHAR(128), " + "address VARCHAR(256), phone VARCHAR(20))");
                System.out.println("Preparing insert statement");
                PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO " + this.mTable + " (id, name, address, phone) VALUES (?, ?, ?, ?)");
                System.out.println("Adding " + this.mNumberOfEntries + " entries to '" + this.mTable + "'...");
                for (int i = 1; i <= this.mNumberOfEntries; ++i) {
                    insertStatement.setString(1, Integer.toString(i));
                    insertStatement.setString(2, this.mData.generateName(i));
                    insertStatement.setString(3, this.mData.generateAddress());
                    insertStatement.setString(4, this.mData.generatePhone());
                    insertStatement.execute();
                }
                Object var9_9 = null;
                if (connection == null) return;
            }
            catch (SQLException e) {
                throw new CreateTestDatabaseException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        connection.close();
        return;
    }
}

