/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate;

import uk.org.ogsadai.client.dbcreate.CreateTestDatabaseException;
import uk.org.ogsadai.client.dbcreate.DataCreator;

public abstract class CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    protected final DataCreator mData = new DataCreator();
    protected String mDBMS;
    protected String mDriver;
    protected String mHost;
    protected String mPort;
    protected String mDatabase;
    protected String mUsername;
    protected String mPassword;
    protected String mTable;
    protected int mNumberOfEntries = 10000;

    public CreateTestDB(String[] args) {
        this.setDefaultSettings();
        if (this.setupArguments(args)) {
            try {
                this.printVariables(this.mDBMS);
                this.populateDatabase();
                System.out.println("Test database created successfully!");
            }
            catch (CreateTestDatabaseException e) {
                System.out.println(e.getLocalizedMessage());
            }
        } else {
            this.printUsage();
            this.printVariables("Default");
        }
    }

    protected abstract void setDefaultSettings();

    protected abstract void populateDatabase() throws CreateTestDatabaseException;

    protected boolean setupArguments(String[] args) {
        if (args.length % 2 == 1) {
            return false;
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].toLowerCase().equals("-driverclass")) {
                this.mDriver = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-host")) {
                this.mHost = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-port")) {
                this.mPort = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-database")) {
                this.mDatabase = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-username")) {
                this.mUsername = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-password")) {
                this.mPassword = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-tablename")) {
                this.mTable = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-rows")) {
                this.mNumberOfEntries = Integer.parseInt(args[i + 1]);
                continue;
            }
            return false;
        }
        return true;
    }

    protected void printUsage() {
        System.out.println("Usage:\njava uk.org.ogsadai.client.dbcreate.CreateTest" + this.mDBMS + "DB " + "[-driverclass " + this.mDBMS + "DriverClass] \n\t\t" + "[-host " + this.mDBMS + "HostName] " + "[-port " + this.mDBMS + "PortNumber] " + "[-database " + this.mDBMS + "DatabaseName] \n\t\t" + "[-username " + this.mDBMS + "UserName] " + "[-password " + this.mDBMS + "Password] \n\t\t" + "[-tablename NameOfTableToCreate] " + "[-rows NumberOfRowsToCreate]");
    }

    protected void printVariables(String prefix) {
        System.out.println(prefix + " Settings:" + "\n\t" + this.mDBMS + "DriverClass:    \t" + this.mDriver + "\n\t" + this.mDBMS + "HostName:       \t" + this.mHost + "\n\t" + this.mDBMS + "PortNumber:     \t" + this.mPort + "\n\t" + this.mDBMS + "DatabaseName:   \t" + this.mDatabase + "\n\t" + this.mDBMS + "UserName:       \t" + this.mUsername + "\n\t" + this.mDBMS + "Password:       \t" + this.mPassword + "\n\tNameOfTableToCreate: \t" + this.mTable + "\n\tNumberOfRowsToCreate:\t" + this.mNumberOfEntries);
    }

    protected void loadDriver() throws CreateTestDatabaseException {
        try {
            Class.forName(this.mDriver);
        }
        catch (ClassNotFoundException e) {
            throw new CreateTestDatabaseException("Cannot find driver class " + this.mDriver, e);
        }
    }
}

