/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import uk.org.ogsadai.client.dbcreate.CreateTestDB;
import uk.org.ogsadai.client.dbcreate.CreateTestDatabaseException;

public class CreateTestCsvDB
extends CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    private String mUserHome;
    private String mFileName;
    private String mFieldSeparator;

    public CreateTestCsvDB(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        CreateTestCsvDB creator = new CreateTestCsvDB(args);
    }

    protected void setDefaultSettings() {
        this.mDBMS = "Csv";
        this.mUserHome = System.getProperty("user.home");
        this.mFileName = "littleblackbook.csv";
        this.mFieldSeparator = ",";
        System.out.println("setDefaultSettings 1: " + this.mUserHome);
    }

    protected void populateDatabase() throws CreateTestDatabaseException {
        PrintWriter out = null;
        try {
            File usrDir = new File(this.mUserHome);
            File f = new File(usrDir, this.mFileName);
            if (f.exists()) {
                System.out.println("Deleting " + this.mFileName + " file in the directory " + this.mUserHome);
                f.delete();
            }
            System.out.println("Creating " + this.mFileName + " file in the directory " + this.mUserHome);
            out = new PrintWriter(new FileWriter(f));
            System.out.println("Adding header");
            out.println("id" + this.mFieldSeparator + "name" + this.mFieldSeparator + "address" + this.mFieldSeparator + "phone");
            System.out.println("Adding " + this.mNumberOfEntries + " entries to '" + this.mFileName + "'...");
            for (int i = 1; i <= this.mNumberOfEntries; ++i) {
                out.print(Integer.toString(i) + this.mFieldSeparator);
                out.print(this.mData.generateName(i) + this.mFieldSeparator);
                out.print("\"" + this.mData.generateAddress() + "\"" + this.mFieldSeparator);
                out.println(this.mData.generatePhone());
            }
        }
        catch (IOException e) {
            throw new CreateTestDatabaseException(e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected boolean setupArguments(String[] args) {
        if (args.length % 2 == 1) {
            return false;
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].toLowerCase().equals("-directory")) {
                this.mUserHome = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-filename")) {
                this.mFileName = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-delimiter")) {
                this.mFieldSeparator = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-rows")) {
                this.mNumberOfEntries = Integer.parseInt(args[i + 1]);
                continue;
            }
            return false;
        }
        return true;
    }

    protected void printUsage() {
        System.out.println("Usage:\njava uk.org.ogsadai.client.dbcreate.CreateTest" + this.mDBMS + "DB [-directory " + this.mDBMS + "Directory]" + "\n\t\t[-filename " + this.mDBMS + "FileName] [-delimiter " + this.mDBMS + "Delimiter]" + "\n\t\t[-rows NumberOfRowsToCreate]");
    }

    protected void printVariables(String prefix) {
        System.out.println(prefix + " Settings:" + "\n\t" + this.mDBMS + "Directory:    \t" + this.mUserHome + "\n\t" + this.mDBMS + "FileName:       \t" + this.mFileName + "\n\t" + this.mDBMS + "Delimiter:     \t" + this.mFieldSeparator + "\n\tNumberOfRowsToCreate:\t" + this.mNumberOfEntries);
    }
}

