/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser.xpath;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import uk.org.ogsadai.client.databrowser.DBGUI;
import uk.org.ogsadai.client.databrowser.DBProgressModel;
import uk.org.ogsadai.client.databrowser.ExtensionFileFilter;
import uk.org.ogsadai.client.databrowser.GUIThread;
import uk.org.ogsadai.client.databrowser.ResultView;
import uk.org.ogsadai.client.databrowser.xpath.DBXMLMenuBar;

public class DBXMLResourceView
extends JFrame
implements ResultView {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final Dimension SCREENSIZE = DBGUI.SCREENSIZE;
    private static final int MAXWIDTH = DBXMLResourceView.SCREENSIZE.width * 2 / 3;
    private static final int MAXHEIGHT = DBXMLResourceView.SCREENSIZE.height * 2 / 3;
    private static final String TITLE = "Query Results";
    private JTextArea mText = new JTextArea();
    private Observable mObservable;
    private boolean mDataHasBeenSaved = false;

    public DBXMLResourceView(Observable model, JFrame parent) {
        super(TITLE);
        this.setIconImage(parent.getIconImage());
        this.setJMenuBar(new DBXMLMenuBar(this));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DBXMLResourceView.this.exit();
            }
        });
        this.mObservable = model;
        this.mObservable.addObserver(this);
        this.mText.setBorder(BorderFactory.createEtchedBorder());
        this.mText.setAlignmentX(0.0f);
        this.mText.setMaximumSize(DBGUI.MAX_COMBOBOX_SIZE);
        this.mText.setEditable(false);
    }

    public void update(Observable observable, Object updatedObject) {
        if (updatedObject instanceof ResourceSet) {
            this.displayResults((ResourceSet)updatedObject);
        }
    }

    private void displayResults(final ResourceSet rs) {
        this.stopObserving();
        final DBProgressModel pm = new DBProgressModel(this);
        GUIThread thread = new GUIThread(){

            public Object setup() {
                try {
                    pm.startTask("Parsing Query Results");
                    StringBuffer buf = new StringBuffer();
                    ResourceIterator iterator = rs.getIterator();
                    while (iterator.hasMoreResources()) {
                        String resourceString = (String)iterator.nextResource().getContent();
                        if (resourceString.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n")) {
                            buf.append(resourceString.substring("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".length(), resourceString.length()));
                            continue;
                        }
                        buf.append(resourceString);
                    }
                    DBXMLResourceView.this.displayResults(buf);
                }
                catch (Exception e) {
                    pm.finishTask();
                    System.out.println("Exception in DBDataView.update\n" + e.getLocalizedMessage());
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(DBXMLResourceView.this.getParent(), "Error displaying data");
                }
                pm.finishTask();
                return null;
            }
        };
        thread.start();
    }

    public void stopObserving() {
        this.mObservable.deleteObserver(this);
    }

    protected void displayResults(StringBuffer buf) {
        this.getContentPane().add(new JScrollPane(this.mText));
        this.mText.setText(buf.toString());
        this.setSize(MAXWIDTH, MAXHEIGHT);
        this.setLocationRelativeTo(this.getOwner());
        this.validate();
        this.show();
    }

    public void saveAsXML() {
        String extension = "xml";
        String description = "XML";
        String defaultDir = ".";
        String defaultFile = "default.xml";
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new ExtensionFileFilter("xml", "XML"));
        chooser.setCurrentDirectory(new File("."));
        chooser.setSelectedFile(new File("default.xml"));
        if (chooser.showSaveDialog(this) == 0) {
            int response;
            File file = chooser.getSelectedFile();
            if (file.getName().indexOf(".") < 0) {
                file = new File(file.getPath() + "." + "xml");
            }
            if (file.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                this.saveAsXML();
            }
            this.writeToFileAsXML(file);
        }
    }

    private void writeToFileAsXML(File file) {
        DBProgressModel pm = new DBProgressModel(this);
        pm.startTask("Saving data");
        File outputFile = file;
        FileWriter out = null;
        try {
            out = new FileWriter(outputFile);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Unable to open file for writing");
            e.printStackTrace();
            pm.finishTask();
            return;
        }
        try {
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            out.write("<results>");
            out.write(this.mText.getText());
            out.write("</results>");
            out.close();
            this.mDataHasBeenSaved = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error writing to file");
            e.printStackTrace();
            pm.finishTask();
            return;
        }
        pm.finishTask();
    }

    public void exit() {
        if (this.mDataHasBeenSaved) {
            this.dispose();
        } else if (JOptionPane.showConfirmDialog(this, "The data will be lost if you have not saved it.\n\nClose window?", "Exit", 2) == 0) {
            this.dispose();
        }
    }

    public boolean dataHasBeenSaved() {
        return this.mDataHasBeenSaved;
    }
}

