/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import uk.org.ogsadai.client.databrowser.DBProgressModel;
import uk.org.ogsadai.client.databrowser.GUIThread;
import uk.org.ogsadai.converters.databaseschema.ColumnMetaData;
import uk.org.ogsadai.converters.databaseschema.DatabaseSchemaMetaData;
import uk.org.ogsadai.converters.databaseschema.KeyMetaData;
import uk.org.ogsadai.converters.databaseschema.TableMetaData;

public class DBSchemaView
extends JFrame
implements Observer {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final String TITLE = "Database Schema";
    private JTabbedPane mTableTabs;
    private Observable mObservable;

    public DBSchemaView(Observable model, JFrame parent) {
        super(TITLE);
        this.setIconImage(parent.getIconImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DBSchemaView.this.exit();
            }
        });
        this.mObservable = model;
        this.mObservable.addObserver(this);
    }

    public void update(Observable observable, Object updatedObject) {
        if (updatedObject instanceof DatabaseSchemaMetaData) {
            this.displayResults((DatabaseSchemaMetaData)updatedObject);
        }
    }

    private void displayResults(final DatabaseSchemaMetaData schema) {
        this.stopObserving();
        final DBProgressModel pm = new DBProgressModel(this);
        GUIThread thread = new GUIThread(){

            public Object setup() {
                try {
                    pm.startTask("Parsing database schema");
                    DBSchemaView.this.buildTables(schema);
                    DBSchemaView.this.displayResults();
                }
                catch (Exception e) {
                    pm.finishTask();
                    System.out.println("Exception in SchemaView.update\n" + e.getLocalizedMessage());
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(DBSchemaView.this.getParent(), "Error displaying schema:\n" + e.getLocalizedMessage());
                }
                pm.finishTask();
                return null;
            }
        };
        thread.start();
    }

    public void stopObserving() {
        this.mObservable.deleteObserver(this);
    }

    protected void buildTables(DatabaseSchemaMetaData schema) throws Exception {
        this.mTableTabs = new JTabbedPane();
        this.showTables(schema);
    }

    protected void showTables(DatabaseSchemaMetaData schema) {
        Map tables = schema.getTables();
        Iterator iterator = tables.keySet().iterator();
        while (iterator.hasNext()) {
            boolean hasPrimaryKey;
            TableMetaData currentTable = (TableMetaData)tables.get(iterator.next());
            Vector rowData = new Vector();
            Vector<String> row = new Vector<String>();
            row.addElement("name");
            rowData.addElement(row);
            row = new Vector();
            row.addElement("full name");
            rowData.addElement(row);
            row = new Vector();
            row.addElement("SQL type");
            rowData.addElement(row);
            row = new Vector();
            row.addElement("Java type ID");
            rowData.addElement(row);
            Vector<String> columnNames = new Vector<String>();
            columnNames.addElement("column");
            boolean bl = hasPrimaryKey = currentTable.getPrimaryKeys().length != 0;
            if (hasPrimaryKey) {
                row = new Vector();
                row.addElement("primary key");
                rowData.addElement(row);
            }
            for (int j = 0; j < currentTable.getColumnCount(); ++j) {
                ColumnMetaData column = currentTable.getColumn(j);
                columnNames.addElement(String.valueOf(j + 1));
                ((Vector)rowData.elementAt(0)).addElement(column.getName());
                ((Vector)rowData.elementAt(1)).addElement(column.getFullName());
                ((Vector)rowData.elementAt(2)).addElement(column.getSQLType());
                ((Vector)rowData.elementAt(3)).addElement(String.valueOf(column.getDataType()));
                if (!hasPrimaryKey) continue;
                if (column.isPrimaryKey()) {
                    ((Vector)rowData.elementAt(4)).addElement("YES");
                    continue;
                }
                ((Vector)rowData.elementAt(4)).addElement("NO");
            }
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout(5, 5));
            SchemaTableModel model = new SchemaTableModel(rowData, columnNames);
            JTable table = new JTable(model);
            table.setAutoResizeMode(0);
            JScrollPane scrollPane = new JScrollPane(table);
            scrollPane.setBorder(BorderFactory.createTitledBorder("Columns"));
            panel.add((Component)scrollPane, "Center");
            JPanel keysPanel = new JPanel();
            keysPanel.setLayout(new BorderLayout(5, 5));
            table = this.makeKeyTable(currentTable.getImportedKeys());
            if (table != null) {
                table.setAutoResizeMode(0);
                scrollPane = new JScrollPane(table);
                scrollPane.setBorder(BorderFactory.createTitledBorder("Imported Keys"));
                keysPanel.add((Component)scrollPane, "North");
            }
            if ((table = this.makeKeyTable(currentTable.getExportedKeys())) != null) {
                table.setAutoResizeMode(0);
                scrollPane = new JScrollPane(table);
                scrollPane.setBorder(BorderFactory.createTitledBorder("Exported Keys"));
                keysPanel.add((Component)scrollPane, "South");
            }
            keysPanel.validate();
            panel.add((Component)keysPanel, "South");
            this.mTableTabs.add((Component)panel, currentTable.getName());
        }
    }

    protected JTable makeKeyTable(KeyMetaData[] keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        Vector<String> columnNames = new Vector<String>();
        columnNames.addElement("foreign key: table");
        columnNames.addElement("foreign key: column");
        columnNames.addElement("primary key: table");
        columnNames.addElement("primary key: column");
        Vector rowData = new Vector();
        for (int i = 0; i < keys.length; ++i) {
            Vector<String> row = new Vector<String>();
            KeyMetaData currentKey = keys[i];
            row.addElement(currentKey.getForeignTableName());
            row.addElement(currentKey.getForeignColumnName());
            row.addElement(currentKey.getPrimaryKeyTableName());
            row.addElement(currentKey.getPrimaryKeyColumnName());
            rowData.addElement(row);
        }
        SchemaTableModel model = new SchemaTableModel(rowData, columnNames);
        JTable keyTable = new JTable(model);
        return keyTable;
    }

    protected void displayResults() {
        this.getContentPane().add(this.mTableTabs);
        this.setLocationRelativeTo(this.getOwner());
        this.validate();
        this.pack();
        this.show();
    }

    public void exit() {
        if (JOptionPane.showConfirmDialog(this, "Press OK to close window", "Exit", 2) == 0) {
            this.dispose();
        }
    }

    protected class SchemaTableModel
    extends DefaultTableModel {
        private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";

        public SchemaTableModel(Vector rows, Vector colNames) {
            super(rows, colNames);
        }

        public Object getValueAt(int row, int col) {
            try {
                return super.getValueAt(row, col);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

