/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser.sql;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import uk.org.ogsadai.client.databrowser.DBClient;
import uk.org.ogsadai.client.databrowser.DBGUI;
import uk.org.ogsadai.client.databrowser.DBProgressModel;
import uk.org.ogsadai.client.databrowser.ExtensionFileFilter;
import uk.org.ogsadai.client.databrowser.GUIThread;
import uk.org.ogsadai.client.databrowser.ResultView;
import uk.org.ogsadai.client.databrowser.sql.DBDataMenuBar;

public class DBResultSetView
extends JFrame
implements ResultView {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final Dimension SCREENSIZE = DBGUI.SCREENSIZE;
    private static final int WIDTH = 150;
    private static final int HEADER_HEIGHT = 70;
    private static final int HEIGHT = 17;
    private static final int MAXWIDTH = DBResultSetView.SCREENSIZE.width * 2 / 3;
    private static final int MAXHEIGHT = DBResultSetView.SCREENSIZE.height * 2 / 3;
    private static final String TITLE = "Query Results";
    private JTable mTable;
    private Observable mObservable;
    private boolean mDataHasBeenSaved = false;

    public DBResultSetView(Observable model, JFrame parent) {
        super(TITLE);
        this.setIconImage(parent.getIconImage());
        this.setJMenuBar(new DBDataMenuBar(this));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DBResultSetView.this.exit();
            }
        });
        this.mObservable = model;
        this.mObservable.addObserver(this);
    }

    public void update(Observable observable, Object updatedObject) {
        if (updatedObject instanceof ResultSet) {
            this.displayResults((ResultSet)updatedObject);
        }
    }

    private void displayResults(final ResultSet rs) {
        this.stopObserving();
        final DBProgressModel pm = new DBProgressModel(this);
        GUIThread thread = new GUIThread(){

            public Object setup() {
                try {
                    rs.last();
                    int numberOfRows = rs.getRow();
                    int rowNumber = 0;
                    pm.startTask("Parsing Query Results", numberOfRows);
                    ResultSetMetaData rsmd = rs.getMetaData();
                    Vector<String> columnHeads = new Vector<String>();
                    Vector<Vector> rows = new Vector<Vector>();
                    int numColumns = rsmd.getColumnCount();
                    for (int index = 1; index <= numColumns; ++index) {
                        columnHeads.addElement(rsmd.getColumnName(index));
                    }
                    rs.beforeFirst();
                    while (rs.next()) {
                        if (++rowNumber % 100 == 0) {
                            pm.status("Parsed " + rowNumber + " rows ", rowNumber);
                        }
                        rows.addElement(DBResultSetView.this.getNextRow(rs, rsmd));
                    }
                    DBResultSetView.this.displayResults(rows, columnHeads);
                }
                catch (Exception e) {
                    pm.finishTask();
                    System.out.println("Exception in DBDataView.update\n" + e.getLocalizedMessage());
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(DBResultSetView.this.getParent(), "Error displaying data");
                }
                pm.finishTask();
                return null;
            }
        };
        thread.start();
    }

    public void stopObserving() {
        this.mObservable.deleteObserver(this);
    }

    protected void displayResults(Vector rows, Vector columnHeads) {
        int width;
        this.mTable = new JTable(rows, columnHeads){

            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.getContentPane().add(new JScrollPane(this.mTable));
        int height = 70 + 17 * rows.size() + 1;
        for (width = 150 * columnHeads.size() + 1; width > MAXWIDTH; width -= 150) {
        }
        while (height > MAXHEIGHT) {
            height -= 17;
        }
        this.setSize(width, height);
        this.setLocationRelativeTo(this.getOwner());
        this.validate();
        this.show();
    }

    private Vector getNextRow(ResultSet rs, ResultSetMetaData rsmd) throws SQLException {
        Vector<Object> currentRow = new Vector<Object>();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            Object o = null;
            try {
                o = rs.getObject(i);
            }
            catch (Exception e) {
                o = null;
            }
            if (o != null) {
                switch (rsmd.getColumnType(i)) {
                    case 1: {
                        currentRow.addElement(rs.getString(i));
                        break;
                    }
                    case 12: {
                        currentRow.addElement(rs.getString(i));
                        break;
                    }
                    case 4: {
                        currentRow.addElement(new Long(rs.getLong(i)));
                        break;
                    }
                    case 2: {
                        currentRow.addElement((Number)rs.getObject(i));
                        break;
                    }
                    case 8: {
                        currentRow.addElement(new Double(rs.getDouble(i)));
                        break;
                    }
                    case 91: {
                        Date date = (Date)rs.getObject(i);
                        currentRow.addElement(date);
                        break;
                    }
                    case 93: {
                        Object date2 = rs.getObject(i);
                        Timestamp date3 = (Timestamp)date2;
                        Date date4 = new Date(date3.getTime());
                        currentRow.addElement(date4);
                        break;
                    }
                    default: {
                        currentRow.addElement(rs.getObject(i).toString());
                        System.out.println("Element retrieval failed: type not implemented");
                        System.out.println("Column Type Name is: " + rsmd.getColumnTypeName(i));
                        System.out.println("Element is an instance of " + o.getClass());
                        break;
                    }
                }
                continue;
            }
            currentRow.addElement(null);
        }
        return currentRow;
    }

    public void saveAsCSV() {
        String extension = "csv";
        String description = "Comma Separated Value";
        String defaultDir = ".";
        String defaultFile = "default.csv";
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new ExtensionFileFilter("csv", "Comma Separated Value"));
        chooser.setCurrentDirectory(new File("."));
        chooser.setSelectedFile(new File("default.csv"));
        if (chooser.showSaveDialog(this) == 0) {
            int response;
            File file = chooser.getSelectedFile();
            if (file.getName().indexOf(".") < 0) {
                file = new File(file.getPath() + "." + "csv");
            }
            if (file.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                this.saveAsCSV();
            }
            this.writeToFileAsCSV(file);
        }
    }

    private void writeToFileAsCSV(File file) {
        String delimiter = ", ";
        DBProgressModel pm = new DBProgressModel(this);
        pm.startTask("Saving data", this.mTable.getRowCount());
        File outputFile = file;
        FileWriter out = null;
        try {
            out = new FileWriter(outputFile);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Unable to open file for writing");
            e.printStackTrace();
            pm.finishTask();
            return;
        }
        try {
            out.write(this.mTable.getColumnName(0));
            for (int k = 1; k < this.mTable.getColumnCount(); ++k) {
                out.write(", " + this.mTable.getColumnName(k));
            }
            out.write(DBClient.NEWLINE);
            for (int i = 0; i < this.mTable.getRowCount(); ++i) {
                if (i % 500 == 0) {
                    pm.status("Saved rows ", i);
                }
                out.write("" + this.mTable.getValueAt(i, 0));
                for (int j = 1; j < this.mTable.getColumnCount(); ++j) {
                    out.write(", " + this.mTable.getValueAt(i, j));
                }
                out.write(DBClient.NEWLINE);
            }
            out.close();
            this.mDataHasBeenSaved = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error writing to file");
            e.printStackTrace();
            pm.finishTask();
            return;
        }
        pm.finishTask();
    }

    public void exit() {
        if (this.mDataHasBeenSaved) {
            this.dispose();
        } else if (JOptionPane.showConfirmDialog(this, "The data will be lost if you have not saved it.\n\nClose window?", "Exit", 2) == 0) {
            this.dispose();
        }
    }

    public boolean dataHasBeenSaved() {
        return this.mDataHasBeenSaved;
    }
}

