/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser.sql;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import uk.org.ogsadai.client.databrowser.DBClient;
import uk.org.ogsadai.client.databrowser.DBDataResource;
import uk.org.ogsadai.client.databrowser.DBDataService;
import uk.org.ogsadai.client.databrowser.DBDataServiceView;
import uk.org.ogsadai.client.databrowser.DBGUI;
import uk.org.ogsadai.client.databrowser.DBMenuController;
import uk.org.ogsadai.client.databrowser.ExtensionFileFilter;
import uk.org.ogsadai.client.databrowser.sql.DBJoinParameter;
import uk.org.ogsadai.client.databrowser.sql.DBJoinSQLTextArea;
import uk.org.ogsadai.client.databrowser.sql.DBQuery;
import uk.org.ogsadai.client.databrowser.sql.DBUpdate;

public class DBJoinDialog
extends JDialog
implements ActionListener {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final Dimension SCREENSIZE = DBGUI.SCREENSIZE;
    private static final int WIDTH = DBJoinDialog.SCREENSIZE.width * 2 / 3;
    private static final int HEIGHT = DBJoinDialog.SCREENSIZE.height * 1 / 2;
    private static final String TITLE = "Join";
    private static final boolean MODAL = true;
    private static final int NUM_OF_DB = 2;
    private static final String EXTENSION = "txt";
    private static final String DESCRIPTION = "Text";
    private static final String DEFAULT_DIR = ".";
    private static final String DEFAULTFILE = "default_join.txt";
    private DBJoinParameter mParameters = new DBJoinParameter();
    private JComboBox[] mSelectURLFrom = new JComboBox[2];
    private DBJoinSQLTextArea[] mTextQuery = new DBJoinSQLTextArea[2];
    private DBJoinSQLTextArea[] mTextCreate = new DBJoinSQLTextArea[2];
    private DBJoinSQLTextArea[] mTextDestroy = new DBJoinSQLTextArea[2];
    private JComboBox mSelectURLTo = new JComboBox();
    private DBJoinSQLTextArea mTextJoin = new DBJoinSQLTextArea();
    private String[] mButtonNames = new String[]{"Save SQL", "Load SQL", "Run", "Cancel"};
    private DBDataServiceView mDataServiceView;
    private DBMenuController mController;

    public DBJoinDialog(DBGUI parent, DBMenuController controller) {
        super(parent, TITLE, true);
        this.mDataServiceView = parent.getDataServiceView();
        this.mController = controller;
        this.setSize(WIDTH, HEIGHT);
        this.setLocationRelativeTo(parent);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DBJoinDialog.this.exit();
            }
        });
        this.initComponents();
        this.show();
    }

    private void initComponents() {
        int i;
        DBDataService[] services = this.mDataServiceView.getDataServices();
        Vector<DBDataResource> list = new Vector<DBDataResource>();
        for (i = 0; i < services.length; ++i) {
            DBDataResource[] resources = services[i].getDataResources();
            for (int j = 0; j < resources.length; ++j) {
                list.addElement(resources[j]);
            }
        }
        this.mSelectURLTo = new JComboBox(list);
        for (i = 0; i < 2; ++i) {
            this.mSelectURLFrom[i] = new JComboBox(list);
            this.mSelectURLFrom[i].setMaximumSize(new Dimension(5000, 1));
            this.mTextQuery[i] = new DBJoinSQLTextArea();
            this.mTextCreate[i] = new DBJoinSQLTextArea();
            this.mTextDestroy[i] = new DBJoinSQLTextArea();
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        JPanel panelFrom = new JPanel(new GridLayout(1, 2, 5, 5));
        panelFrom.add(this.createFromPanel(0));
        panelFrom.add(this.createFromPanel(1));
        mainPanel.add(panelFrom);
        JPanel panelTo = new JPanel();
        panelTo.setLayout(new BoxLayout(panelTo, 2));
        panelTo.add(Box.createRigidArea(new Dimension(WIDTH / 5, 0)));
        panelTo.add(this.createJoinPanel());
        panelTo.add(Box.createRigidArea(new Dimension(WIDTH / 5, 0)));
        mainPanel.add(panelTo);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 6, 5, 5));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(Box.createHorizontalGlue());
        for (int i2 = 0; i2 < this.mButtonNames.length; ++i2) {
            JButton button = new JButton(this.mButtonNames[i2]);
            button.addActionListener(this);
            button.setActionCommand(this.mButtonNames[i2]);
            buttonPanel.add(button);
        }
        mainPanel.add(Box.createRigidArea(new Dimension(0, HEIGHT / 10)));
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
    }

    private JPanel createJoinPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JLabel label1 = new JLabel("Select database where join will take place");
        JLabel label2 = new JLabel("Enter Join SQL query");
        label1.setAlignmentX(0.0f);
        label2.setAlignmentX(0.0f);
        this.mSelectURLTo.setAlignmentX(0.0f);
        JScrollPane scroll1 = new JScrollPane(this.mTextJoin);
        scroll1.setHorizontalScrollBarPolicy(31);
        scroll1.setAlignmentX(0.0f);
        this.mSelectURLTo.setMaximumSize(new Dimension(5000, 1));
        panel.add(label1);
        panel.add(this.mSelectURLTo);
        panel.add(label2);
        panel.add(scroll1);
        panel.add(Box.createRigidArea(new Dimension(5, 5)));
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private void load() {
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new ExtensionFileFilter(EXTENSION, DESCRIPTION));
        chooser.setCurrentDirectory(new File(DEFAULT_DIR));
        chooser.setSelectedFile(new File(DEFAULTFILE));
        if (chooser.showOpenDialog(this) == 0) {
            this.readParameters(chooser.getSelectedFile());
        }
    }

    private void save() {
        this.setParameters();
        if (this.mParameters.isValid()) {
            JFileChooser chooser = new JFileChooser();
            chooser.addChoosableFileFilter(new ExtensionFileFilter(EXTENSION, DESCRIPTION));
            chooser.setCurrentDirectory(new File(DEFAULT_DIR));
            chooser.setSelectedFile(new File(DEFAULTFILE));
            if (chooser.showSaveDialog(this) == 0) {
                int response;
                File file = chooser.getSelectedFile();
                if (file.getName().indexOf(DEFAULT_DIR) < 0) {
                    file = new File(file.getPath() + DEFAULT_DIR + EXTENSION);
                }
                if (file.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                    this.writeParameters(file);
                }
                this.writeParameters(file);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Invalid join parameters.");
        }
    }

    private void runJoin() {
        this.setParameters();
        if (this.mParameters.isValid()) {
            this.mController.runJoin(this.mParameters);
        } else {
            JOptionPane.showMessageDialog(this, "Invalid join parameters.");
        }
    }

    private void setParameters() {
        DBDataResource serviceC = (DBDataResource)this.mSelectURLTo.getSelectedItem();
        this.mParameters.setCreateTableA(new DBUpdate("Create A", serviceC, this.mTextCreate[0].getSQLStatement()));
        this.mParameters.setCreateTableB(new DBUpdate("Create B", serviceC, this.mTextCreate[1].getSQLStatement()));
        this.mParameters.setQueryA(new DBQuery("Query A", (DBDataResource)this.mSelectURLFrom[0].getSelectedItem(), this.mTextQuery[0].getSQLStatement()));
        this.mParameters.setQueryB(new DBQuery("Query B", (DBDataResource)this.mSelectURLFrom[1].getSelectedItem(), this.mTextQuery[1].getSQLStatement()));
        this.mParameters.setDestroyTableA(new DBUpdate("Drop A", serviceC, this.mTextDestroy[0].getSQLStatement()));
        this.mParameters.setDestroyTableB(new DBUpdate("Drop B", serviceC, this.mTextDestroy[1].getSQLStatement()));
        this.mParameters.setDataResourceC(serviceC);
        this.mParameters.setQueryJoin(new DBQuery("Query Join", serviceC, this.mTextJoin.getSQLStatement()));
    }

    private JPanel createFromPanel(int index) {
        char db = 'A';
        for (int i = 0; i < index; ++i) {
            db = (char)(db + 1);
        }
        JLabel label1 = new JLabel("Select database " + db);
        JLabel label2 = new JLabel("Enter SQL query e.g. SELECT number AS col1name, address FROM " + db);
        JLabel label3 = new JLabel("<HTML>Enter create table statement for results of query " + db + ", e.g. <br>CREATE TABLE TMP" + db + "(col1name INT, address VARCHAR(20) ...)</HTML>");
        JLabel label4 = new JLabel("<HTML>Enter destroy table statement for temporary table, e.g. <br>DROP TABLE TMP" + db + "</HTML>");
        label1.setAlignmentX(0.0f);
        label2.setAlignmentX(0.0f);
        label3.setAlignmentX(0.0f);
        label4.setAlignmentX(0.0f);
        this.mSelectURLFrom[index].setAlignmentX(0.0f);
        JScrollPane scroll1 = new JScrollPane(this.mTextQuery[index]);
        JScrollPane scroll2 = new JScrollPane(this.mTextCreate[index]);
        JScrollPane scroll3 = new JScrollPane(this.mTextDestroy[index]);
        scroll1.setHorizontalScrollBarPolicy(31);
        scroll2.setHorizontalScrollBarPolicy(31);
        scroll3.setHorizontalScrollBarPolicy(31);
        scroll1.setAlignmentX(0.0f);
        scroll2.setAlignmentX(0.0f);
        scroll3.setAlignmentX(0.0f);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(label1);
        panel.add(this.mSelectURLFrom[index]);
        panel.add(label2);
        panel.add(scroll1);
        panel.add(label3);
        panel.add(scroll2);
        panel.add(label4);
        panel.add(scroll3);
        panel.add(Box.createRigidArea(new Dimension(5, 5)));
        return panel;
    }

    private void exit() {
        if (JOptionPane.showConfirmDialog(this, "Close this window?", "Close", 2) == 0) {
            this.dispose();
        }
    }

    private void readParameters(File inFile) {
        String line = "";
        Vector<String> items = new Vector<String>();
        FileReader in = null;
        try {
            if (inFile.exists()) {
                in = new FileReader(inFile);
                BufferedReader input = new BufferedReader(in);
                while ((line = input.readLine()) != null) {
                    items.addElement(line);
                }
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSQLStatements(items);
    }

    private void setSQLStatements(Vector items) {
        int index = 0;
        for (int i = 0; i < 2; ++i) {
            this.mTextQuery[i].setSQLStatement((String)items.get(index));
            this.mTextCreate[i].setSQLStatement((String)items.get(++index));
            this.mTextDestroy[i].setSQLStatement((String)items.get(++index));
            ++index;
        }
        this.mTextJoin.setSQLStatement((String)items.get(index));
    }

    private Vector getSQLStatements() {
        Vector<String> items = new Vector<String>();
        for (int i = 0; i < 2; ++i) {
            items.addElement(this.mTextQuery[i].getText());
            items.addElement(this.mTextCreate[i].getText());
            items.addElement(this.mTextDestroy[i].getText());
        }
        items.addElement(this.mTextJoin.getText());
        return items;
    }

    private void writeParameters(File outFile) {
        Vector items = this.getSQLStatements();
        try {
            FileWriter out = new FileWriter(outFile);
            BufferedWriter output = new BufferedWriter(out);
            String line = "";
            for (int i = 0; i < items.size(); ++i) {
                StringTokenizer tokens = new StringTokenizer(items.get(i).toString(), DBClient.NEWLINE);
                line = tokens.nextToken();
                while (tokens.hasMoreTokens()) {
                    line = line + " " + tokens.nextToken();
                }
                output.write(line + DBClient.NEWLINE);
            }
            output.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(this.mButtonNames[0])) {
            this.save();
        } else if (command.equals(this.mButtonNames[1])) {
            this.load();
        } else if (command.equals(this.mButtonNames[2])) {
            this.runJoin();
            this.dispose();
        } else if (command.equals(this.mButtonNames[3])) {
            this.exit();
        }
    }
}

