/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser.sql;

import java.sql.ResultSet;
import java.util.StringTokenizer;
import uk.org.ogsadai.client.databrowser.DBProgressModel;
import uk.org.ogsadai.client.databrowser.sql.DBJoinParameter;
import uk.org.ogsadai.client.databrowser.sql.DBUpdate;
import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.TimeoutProperty;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.delivery.DTOutputStream;
import uk.org.ogsadai.client.toolkit.activity.delivery.DataTransportMode;
import uk.org.ogsadai.client.toolkit.activity.delivery.DeliverFromDT;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLBulkLoad;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activity.sql.WebRowSet;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.sessions.JoinExistingSession;
import uk.org.ogsadai.client.toolkit.sessions.Session;

public class DBJoin {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2006.";
    private static final DataTransportMode MODE = DataTransportMode.BLOCK;
    private static final int TEN_MINUTES = 600000;
    private static final TimeoutProperty TEN_MINUTE_TIMEOUT = new TimeoutProperty(600000);

    /*
     * Loose catch block
     */
    public ResultSet join(DBProgressModel pm, DBJoinParameter params) throws Exception {
        ResultSet resultSet;
        Response response;
        boolean droppedTables;
        DataService serviceTo;
        block9: {
            serviceTo = null;
            droppedTables = false;
            pm.startTask("Join", 10);
            pm.status("Fetching data resources");
            DataService serviceFromA = GenericServiceFetcher.getInstance().getDataService(params.getQueryA().getDataServiceURL(), params.getQueryA().getDataResourceName());
            DataService serviceFromB = GenericServiceFetcher.getInstance().getDataService(params.getQueryB().getDataServiceURL(), params.getQueryB().getDataResourceName());
            serviceTo = GenericServiceFetcher.getInstance().getDataService(params.getDataResourceC().getDataService().getDataServiceURL().toString(), params.getDataResourceC().getResourceID().getName());
            serviceFromA.setConnectionProperty(TEN_MINUTE_TIMEOUT);
            serviceFromB.setConnectionProperty(TEN_MINUTE_TIMEOUT);
            serviceTo.setConnectionProperty(TEN_MINUTE_TIMEOUT);
            pm.status("Creating intermediate tables");
            this.createTable(serviceTo, params.getCreateTableA());
            this.createTable(serviceTo, params.getCreateTableB());
            pm.status("Performing BulkLoad A into intermediate table");
            Session serviceFromASession = serviceFromA.createSession();
            this.performBulkLoad(this.launchOutputActivity(params.getQueryA().getSQLQuery(), params.getQueryA().getWebRowSet(), serviceFromA, serviceFromASession), this.getTableName(params.getDestroyTableA()), serviceFromA, serviceTo);
            serviceFromA.closeSession(serviceFromASession);
            pm.status("Performing BulkLoad B into intermediate table");
            Session serviceFromBSession = serviceFromB.createSession();
            this.performBulkLoad(this.launchOutputActivity(params.getQueryB().getSQLQuery(), params.getQueryB().getWebRowSet(), serviceFromB, serviceFromBSession), this.getTableName(params.getDestroyTableB()), serviceFromB, serviceTo);
            serviceFromB.closeSession(serviceFromBSession);
            pm.status("Running the join query");
            ActivityRequest request = new ActivityRequest();
            request.add(params.getQueryJoin().getSQLQuery());
            request.add(params.getQueryJoin().getWebRowSet());
            response = serviceTo.perform(request);
            pm.status("Dropping intermediate tables");
            this.destroyTable(serviceTo, params.getDestroyTableA());
            this.destroyTable(serviceTo, params.getDestroyTableB());
            pm.finishTask();
            droppedTables = true;
            resultSet = params.getQueryJoin().getResultSet();
            Object var13_13 = null;
            if (droppedTables || serviceTo == null) break block9;
            try {
                pm.status("Trying to drop intermediate tables");
                this.destroyTable(serviceTo, params.getDestroyTableA());
                this.destroyTable(serviceTo, params.getDestroyTableB());
            }
            catch (Exception e2) {
                System.out.println("Error while trying to drop intermediate tables");
                e2.printStackTrace();
            }
        }
        pm.finishTask();
        return resultSet;
        {
            catch (Exception e) {
                try {
                    System.out.println("Error: Response was\n" + response.getAsString());
                    throw e;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    if (!droppedTables && serviceTo != null) {
                        try {
                            pm.status("Trying to drop intermediate tables");
                            this.destroyTable(serviceTo, params.getDestroyTableA());
                            this.destroyTable(serviceTo, params.getDestroyTableB());
                        }
                        catch (Exception e2) {
                            System.out.println("Error while trying to drop intermediate tables");
                            e2.printStackTrace();
                        }
                    }
                    pm.finishTask();
                    throw throwable;
                }
            }
        }
    }

    private String getTableName(DBUpdate update) {
        StringTokenizer tokens = new StringTokenizer(update.getStatement());
        String name = "";
        while (tokens.hasMoreTokens()) {
            name = tokens.nextToken();
        }
        return name;
    }

    private void destroyTable(DataService service, DBUpdate dropTable) throws Exception {
        service.perform(dropTable.getSQLUpdate());
    }

    private void createTable(DataService service, DBUpdate createTable) throws Exception {
        service.perform(createTable.getSQLUpdate());
    }

    private DTOutputStream launchOutputActivity(SQLQuery query, WebRowSet webrowset, DataService service, Session session) throws Exception {
        DTOutputStream outputStream = new DTOutputStream();
        outputStream.setInput(webrowset.getOutput());
        ActivityRequest request = new ActivityRequest();
        request.add(query);
        request.add(webrowset);
        request.add(outputStream);
        request.setSessionRequirements(new JoinExistingSession(session));
        service.perform(request);
        return outputStream;
    }

    private void performBulkLoad(DTOutputStream outputStream, String tableNameTo, DataService serviceFrom, DataService serviceTo) throws Exception {
        DeliverFromDT getResults = new DeliverFromDT();
        getResults.setDataTransportInput(outputStream.getDataTransport());
        getResults.setDataTransportMode(MODE);
        SQLBulkLoad loadResults = new SQLBulkLoad(getResults.getOutput(), tableNameTo);
        ActivityRequest bulkloadRequest = new ActivityRequest();
        bulkloadRequest.add(getResults);
        bulkloadRequest.add(loadResults);
        serviceTo.perform(bulkloadRequest);
    }
}

