/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import uk.org.ogsadai.client.databrowser.DBRequestPanel;
import uk.org.ogsadai.client.databrowser.DBRequestView;
import uk.org.ogsadai.client.databrowser.ExtensionFileFilter;

public class DBRequestController
extends JPanel
implements ActionListener {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final String EXTENSION = "txt";
    private static final String DESCRIPTION = "Text";
    private static final String DEFAULT_DIR = ".";
    private static final String DEFAULTFILE = "default.txt";
    private DBRequestPanel mRequestPanel;
    private DBRequestView mRequestView;
    private String[] mButtonNames = new String[]{"Save Query ...", "Load Query ..."};

    public DBRequestController(DBRequestPanel panel) {
        this.mRequestPanel = panel;
        this.mRequestView = this.mRequestPanel.getRequestView();
        this.setLayout(new GridLayout(this.mButtonNames.length, 1, 5, 5));
        if (this.mButtonNames != null) {
            for (int i = 0; i < this.mButtonNames.length; ++i) {
                JButton button = new JButton(this.mButtonNames[i]);
                button.addActionListener(this);
                button.setActionCommand(this.mButtonNames[i]);
                this.add(button);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(this.mButtonNames[0])) {
            this.saveQuery();
        } else if (command.equals(this.mButtonNames[1])) {
            this.loadQuery();
        }
    }

    private void loadQuery() {
        JFileChooser chooser = new JFileChooser();
        String statement = null;
        chooser.addChoosableFileFilter(new ExtensionFileFilter(EXTENSION, DESCRIPTION));
        chooser.setCurrentDirectory(new File(DEFAULT_DIR));
        chooser.setSelectedFile(new File(DEFAULTFILE));
        if (chooser.showOpenDialog(this) == 0) {
            statement = this.readFromFile(chooser.getSelectedFile());
        }
        if (statement != null) {
            this.mRequestView.setQueryStatement(statement);
        }
    }

    private String readFromFile(File inputFile) {
        String statement = "";
        FileReader in = null;
        try {
            in = new FileReader(inputFile);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Unable to open file for reading");
            e.printStackTrace();
            return null;
        }
        try {
            int c;
            while ((c = in.read()) != -1) {
                statement = statement + (char)c;
            }
            in.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error reading from file");
            e.printStackTrace();
            return null;
        }
        return statement;
    }

    private void saveQuery() {
        String statement = this.mRequestView.getQueryStatement();
        if (statement.length() > 0) {
            JFileChooser chooser = new JFileChooser();
            chooser.addChoosableFileFilter(new ExtensionFileFilter(EXTENSION, DESCRIPTION));
            chooser.setCurrentDirectory(new File(DEFAULT_DIR));
            chooser.setSelectedFile(new File(DEFAULTFILE));
            if (chooser.showSaveDialog(this) == 0) {
                int response;
                File file = chooser.getSelectedFile();
                if (file.getName().indexOf(DEFAULT_DIR) < 0) {
                    file = new File(file.getPath() + DEFAULT_DIR + EXTENSION);
                }
                if (file.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                    this.saveQuery();
                }
                this.writeToFile(statement, file);
            }
        } else {
            JOptionPane.showMessageDialog(this.getParent(), "Please enter a query!");
        }
    }

    private void writeToFile(String statement, File outputFile) {
        FileWriter out = null;
        try {
            out = new FileWriter(outputFile);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Unable to open file for writing");
            e.printStackTrace();
            return;
        }
        try {
            out.write(statement);
            out.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error writing to file");
            e.printStackTrace();
            return;
        }
    }
}

