/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import uk.org.ogsadai.client.databrowser.DBDataResource;
import uk.org.ogsadai.client.databrowser.DBGUI;
import uk.org.ogsadai.client.databrowser.DBModel;
import uk.org.ogsadai.client.databrowser.DBProgressModel;
import uk.org.ogsadai.client.databrowser.DBRequestView;
import uk.org.ogsadai.client.databrowser.GUIThread;
import uk.org.ogsadai.client.databrowser.ResultView;
import uk.org.ogsadai.client.databrowser.commands.Command;
import uk.org.ogsadai.client.databrowser.commands.CommandFactory;

public class DBQueryController
extends JPanel
implements ActionListener,
Observer {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    public static final String SQL_QUERY = "SQL Query";
    public static final String SQL_UPDATE = "SQL Update";
    public static final String XPATH_QUERY = "XPath Query";
    public static final String XQUERY_REQUEST = "XQuery Request";
    public static final String SQL_BAG = "SQL Bag";
    public static final String SQL_RESILIENT = "SQL Resilient";
    private static Map mActivities = new HashMap();
    private DBGUI mGUI;
    private DBModel mModel;
    private DBRequestView mRequestView;
    private DBDataResource mDataResource = null;
    private Vector mSupportedActivities;
    private String[] mButtonNames = new String[0];

    public DBQueryController(DBGUI gui, DBModel model, DBRequestView requestView) {
        this.mGUI = gui;
        this.mGUI.getDataServiceView().addObserver(this);
        this.mModel = model;
        this.mRequestView = requestView;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        for (int i = 0; i < this.mButtonNames.length && !command.equals(this.mButtonNames[i]); ++i) {
        }
    }

    private void updateButtons() {
        this.removeAll();
        this.setLayout(new FlowLayout(4));
        if (this.mButtonNames != null) {
            for (int i = 0; i < this.mButtonNames.length; ++i) {
                JButton button = new JButton(this.mButtonNames[i]);
                button.addActionListener(CommandFactory.create(this.mButtonNames[i], this));
                button.setActionCommand(this.mButtonNames[i]);
                this.add(button);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void runCommand(final Command command) {
        if (this.mDataResource == null) {
            JOptionPane.showMessageDialog(this.getParent(), "Please select a database to query");
        } else {
            String statement = this.mRequestView.getQueryStatement();
            if (statement.length() > 0) {
                final DBProgressModel pm = new DBProgressModel(this.mGUI);
                GUIThread thread = new GUIThread(){

                    public Object setup() {
                        pm.startTask("Running the request");
                        ResultView dataView = command.getResultView(DBQueryController.this.mGUI);
                        try {
                            Object result = command.executeRequest(DBQueryController.this.mDataResource, DBQueryController.this.mRequestView.getQueryStatement());
                            pm.finishTask();
                            command.updateObservers(result);
                        }
                        catch (Exception e) {
                            pm.finishTask();
                            if (dataView != null) {
                                dataView.stopObserving();
                            }
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(DBQueryController.this.getParent(), "Unable to execute runQuery\n" + e.getLocalizedMessage());
                        }
                        return null;
                    }
                };
                thread.start();
            } else {
                JOptionPane.showMessageDialog(this.getParent(), "Please enter a query!");
            }
        }
    }

    public void setDataResource(DBDataResource resource) {
        this.mDataResource = resource;
        if (this.mDataResource != null) {
            this.mSupportedActivities = this.mDataResource.getSupportedActivities();
            Vector<String> names = new Vector<String>();
            for (int i = 0; i < this.mSupportedActivities.size(); ++i) {
                Object obj = mActivities.get(this.mSupportedActivities.get(i));
                if (obj == null) continue;
                names.add((String)obj);
            }
            this.mButtonNames = new String[names.size()];
            names.copyInto(this.mButtonNames);
        } else {
            this.mButtonNames = new String[0];
        }
        this.updateButtons();
    }

    public void update(Observable observable, Object obj) {
        if (obj instanceof DBDataResource) {
            this.setDataResource((DBDataResource)obj);
        } else {
            this.setDataResource(null);
        }
    }

    static {
        mActivities.put("sqlQueryStatement", SQL_QUERY);
        mActivities.put("sqlUpdateStatement", SQL_UPDATE);
        mActivities.put("xPathStatement", XPATH_QUERY);
        mActivities.put("xQueryStatement", XQUERY_REQUEST);
        mActivities.put("sqlBag", SQL_BAG);
        mActivities.put("sqlResilient", SQL_RESILIENT);
    }
}

