/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import uk.org.ogsadai.client.databrowser.DBGUI;
import uk.org.ogsadai.client.databrowser.DBProgressModel;

public class DBProgressView
implements Observer {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final int WIDTH = DBGUI.SCREENSIZE.width / 3;
    private static final int HEIGHT = WIDTH / 2;
    private static final String TITLE = "Progress";
    private static final boolean MODAL = false;
    private static final MouseAdapter MOUSEADAPTER = new MouseAdapter(){};
    private static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    private JRootPane mParentRootPane;
    private JDialog mProgressDialog;
    private DBProgressModel mProgressModel;
    private JLabel mTaskname = new JLabel();
    private JLabel mSubtaskname = new JLabel();
    private JProgressBar mProgressBar = new JProgressBar();

    public DBProgressView(JFrame parent, Observable observable) {
        this.mProgressDialog = new JDialog(parent, TITLE, false);
        this.mParentRootPane = parent.getRootPane();
        this.initialise(observable);
    }

    public DBProgressView(JDialog parent, Observable observable) {
        this.mProgressDialog = new JDialog(parent, TITLE, false);
        this.mParentRootPane = parent.getRootPane();
        this.initialise(observable);
    }

    private void initialise(Observable observable) {
        observable.addObserver(this);
        this.mProgressModel = (DBProgressModel)observable;
        this.mProgressBar.setStringPainted(true);
        this.mProgressBar.setString("");
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(new GridLayout(4, 1, 5, 5));
        panel.add(this.mTaskname);
        panel.add(this.mSubtaskname);
        panel.add(this.mProgressBar);
        panel.add(Box.createVerticalGlue());
        this.mProgressDialog.setSize(WIDTH, HEIGHT);
        this.mProgressDialog.getContentPane().add(panel);
        this.mProgressDialog.setLocationRelativeTo(this.mParentRootPane);
        this.mProgressDialog.setDefaultCloseOperation(0);
    }

    public void update(Observable observable, Object updatedObject) {
        if (updatedObject instanceof String) {
            this.setProgress((String)updatedObject);
        } else if (updatedObject instanceof Integer) {
            switch ((Integer)updatedObject) {
                case -1: {
                    this.mProgressBar.setIndeterminate(true);
                    this.start();
                    break;
                }
                case 1: {
                    this.start();
                    break;
                }
                case 2: {
                    this.finish();
                    break;
                }
            }
        }
    }

    private void start() {
        this.mTaskname.setText(this.mProgressModel.getTaskname());
        this.mSubtaskname.setText("");
        if (!this.mProgressBar.isIndeterminate()) {
            this.mProgressBar.setMinimum(0);
            this.mProgressBar.setMaximum(this.mProgressModel.getNumberOfTasks());
            this.mProgressBar.setValue(0);
        }
        DBProgressView.startWaitCursor(this.mParentRootPane);
        this.mProgressDialog.show();
        DBProgressView.startWaitCursor(this.mProgressDialog.getRootPane());
    }

    private void setProgress(String message) {
        this.mSubtaskname.setText(message);
        if (!this.mProgressBar.isIndeterminate()) {
            int subTask = this.mProgressModel.getSubTask();
            this.mProgressBar.setString("Performing task " + subTask + " of " + this.mProgressBar.getMaximum());
            this.mProgressBar.setValue(subTask);
        }
    }

    private void finish() {
        if (this.mProgressBar.isIndeterminate()) {
            this.mProgressBar.setIndeterminate(false);
        }
        DBProgressView.stopWaitCursor(this.mProgressDialog.getRootPane());
        this.mProgressDialog.hide();
        DBProgressView.stopWaitCursor(this.mParentRootPane);
        this.mProgressBar.setValue(0);
        this.mProgressBar.setString("");
        this.mTaskname.setText("");
        this.mSubtaskname.setText("");
    }

    public static void startWaitCursor(JComponent component) {
        RootPaneContainer root = (RootPaneContainer)((Object)component.getRootPane().getTopLevelAncestor());
        root.getGlassPane().setCursor(WAIT_CURSOR);
        root.getGlassPane().addMouseListener(MOUSEADAPTER);
        root.getGlassPane().setVisible(true);
    }

    public static void stopWaitCursor(JComponent component) {
        RootPaneContainer root = (RootPaneContainer)((Object)component.getRootPane().getTopLevelAncestor());
        root.getGlassPane().setCursor(DEFAULT_CURSOR);
        root.getGlassPane().removeMouseListener(MOUSEADAPTER);
        root.getGlassPane().setVisible(false);
    }
}

