/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.util.Observable;
import javax.swing.JDialog;
import javax.swing.JFrame;
import uk.org.ogsadai.client.databrowser.DBProgressView;

public class DBProgressModel
extends Observable {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    public static final int INDETERMINATE = -1;
    public static final int STARTED = 1;
    public static final int FINISHED = 2;
    private static final String NO_TASKNAME = "Unspecified taskname";
    private static final String NO_SUBTASKNAME = "Subtask completed";
    private DBProgressView mProgressView;
    private int mSubtask = 0;
    private String mTaskname = "";
    private int mNumberOfTasks = 0;

    public DBProgressModel(JFrame frame) {
        this.mProgressView = new DBProgressView(frame, (Observable)this);
    }

    public DBProgressModel(JDialog dialog) {
        this.mProgressView = new DBProgressView(dialog, (Observable)this);
    }

    private void updateObservers(Object obj) {
        this.setChanged();
        this.notifyObservers(obj);
    }

    public void startTask(String taskname) {
        this.startTask(taskname, -1);
    }

    public void startTask(String taskname, int numberOfTasks) {
        this.mTaskname = taskname.equals("") ? NO_TASKNAME : taskname;
        if (numberOfTasks <= 0 || numberOfTasks == -1) {
            this.mNumberOfTasks = 0;
            this.updateObservers(new Integer(-1));
        } else {
            this.mNumberOfTasks = numberOfTasks;
            this.mSubtask = 0;
            this.updateObservers(new Integer(1));
        }
    }

    public void status(String message) {
        this.updateStatus(message, this.getSubTask() + 1);
    }

    public void status(String message, int subtask) {
        this.updateStatus(message, subtask);
    }

    private void updateStatus(String message, int subtask) {
        this.setSubTask(subtask);
        if (message.equals("")) {
            message = NO_SUBTASKNAME;
        }
        this.updateObservers(message);
    }

    public void finishTask() {
        this.updateObservers(new Integer(2));
    }

    public String getTaskname() {
        return this.mTaskname;
    }

    public int getNumberOfTasks() {
        return this.mNumberOfTasks;
    }

    private void setSubTask(int subtask) {
        this.mSubtask = subtask <= 0 ? -1 : (subtask > this.mNumberOfTasks ? this.mNumberOfTasks : subtask);
    }

    public int getSubTask() {
        return this.mSubtask;
    }
}

