/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.sql.ResultSet;
import java.util.Observable;
import java.util.Vector;
import uk.org.ogsadai.client.databrowser.DBDataResource;
import uk.org.ogsadai.client.databrowser.DBDataService;
import uk.org.ogsadai.client.databrowser.DBProgressModel;
import uk.org.ogsadai.client.databrowser.sql.DBJoin;
import uk.org.ogsadai.client.databrowser.sql.DBJoinParameter;
import uk.org.ogsadai.converters.databaseschema.DatabaseSchemaMetaData;

public class DBModel
extends Observable {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private Vector mDataServices = new Vector();

    public void updateObservers(Object obj) {
        this.setChanged();
        this.notifyObservers(obj);
    }

    public void addDataService(String url, DBProgressModel progressModel) throws Exception {
        try {
            DBDataService service = new DBDataService(url, progressModel);
            for (int i = 0; i < this.mDataServices.size(); ++i) {
                if (!service.getDataServiceURL().equals(((DBDataService)this.mDataServices.get(i)).getDataServiceURL())) continue;
                throw new Exception("Data service already exists with this URL\n");
            }
            this.mDataServices.addElement(service);
            this.updateObservers(this.mDataServices);
        }
        catch (Exception e) {
            throw new Exception("Data Service URL: " + url + "\n" + "Failure adding service\n" + "Exception message: " + e.getLocalizedMessage());
        }
    }

    public void removeDataService(DBDataService service) {
        this.mDataServices.remove(service);
        this.updateObservers(this.mDataServices);
    }

    public Vector getDataServices() {
        return this.mDataServices;
    }

    public Vector getDataServiceURLs() {
        Vector<String> dataServiceURLs = new Vector<String>();
        for (int i = 0; i < this.mDataServices.size(); ++i) {
            String url = ((DBDataService)this.mDataServices.get(i)).getDataServiceURL().toString();
            dataServiceURLs.add(url);
        }
        return dataServiceURLs;
    }

    public Vector getDataResourceIDs() {
        Vector<String> resourceIDs = new Vector<String>();
        for (int i = 0; i < this.mDataServices.size(); ++i) {
            DBDataResource[] resources = ((DBDataService)this.mDataServices.get(i)).getDataResources();
            for (int j = 0; j < resources.length; ++j) {
                resourceIDs.add(resources[j].getResourceID().getName());
            }
        }
        return resourceIDs;
    }

    public void runJoin(DBProgressModel pm, DBJoinParameter parameters) throws Exception {
        DBJoin join = new DBJoin();
        ResultSet rs = join.join(pm, parameters);
        this.updateObservers(rs);
    }

    public void retrieveSchema(DBProgressModel model, DBDataResource service) throws Exception {
        DatabaseSchemaMetaData schema = service.getDatabaseSchema();
        this.updateObservers(schema);
    }
}

