/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.org.ogsadai.client.databrowser.DBGUI;

public class DBMessageLevelSecuritySettingsDialog
extends JDialog
implements ActionListener {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final String TITLE = "Message Level Security Settings";
    private static final boolean MODAL = true;
    private JComboBox mAuthentication;
    private JCheckBox mIntegrity;
    private JCheckBox mPrivacy;
    private JComboBox mDelegation;
    private boolean mIsIntegrityEnabled;
    private boolean mIsPrivacyEnabled;
    private String mAuthenticationMechanism;
    private String mDelegationLevel;
    private boolean mCancel;
    private String[] mButtonNames = new String[]{"OK", "Cancel"};

    public DBMessageLevelSecuritySettingsDialog(DBGUI parent) {
        super(parent, TITLE, true);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.pack();
        this.show();
    }

    private void initComponents() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        buttonPanel.setAlignmentX(0.0f);
        for (int i = 0; i < this.mButtonNames.length; ++i) {
            JButton button = new JButton(this.mButtonNames[i]);
            button.addActionListener(this);
            button.setActionCommand(this.mButtonNames[i]);
            buttonPanel.add(button);
        }
        this.mAuthentication = new JComboBox<String>(new String[]{"host", "self", "none"});
        this.mAuthentication.setMaximumSize(DBGUI.MAX_COMBOBOX_SIZE);
        this.mAuthentication.setAlignmentX(0.0f);
        this.mIntegrity = new JCheckBox("Integrity");
        this.mPrivacy = new JCheckBox("Privacy");
        this.mDelegation = new JComboBox<String>(new String[]{"full", "limited", "none"});
        this.mDelegation.setMaximumSize(DBGUI.MAX_COMBOBOX_SIZE);
        this.mDelegation.setAlignmentX(0.0f);
        JLabel label1 = new JLabel("Authentication Mechanism:");
        JLabel label2 = new JLabel("GSI Secure Conversation Settings:");
        JLabel label3 = new JLabel("Delegation Level:");
        label1.setAlignmentX(0.0f);
        label2.setAlignmentX(0.0f);
        label3.setAlignmentX(0.0f);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel temp = new JPanel();
        temp.add(label1);
        temp.add(this.mAuthentication);
        temp.setBorder(BorderFactory.createEtchedBorder());
        panel.add(temp);
        temp = new JPanel();
        temp.add(label2);
        temp.setBorder(BorderFactory.createEtchedBorder());
        JPanel pan = new JPanel();
        pan.setLayout(new GridLayout(2, 1));
        pan.add(this.mIntegrity);
        pan.add(this.mPrivacy);
        temp.add(pan);
        panel.add(temp);
        temp = new JPanel();
        temp.add(label3);
        temp.add(this.mDelegation);
        temp.setBorder(BorderFactory.createEtchedBorder());
        panel.add(temp);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(this.mButtonNames[0])) {
            this.hide();
            this.mIsIntegrityEnabled = this.mIntegrity.isSelected();
            this.mIsPrivacyEnabled = this.mPrivacy.isSelected();
            this.mAuthenticationMechanism = (String)this.mAuthentication.getSelectedItem();
            this.mDelegationLevel = (String)this.mDelegation.getSelectedItem();
            this.mCancel = false;
            this.dispose();
        } else if (command.equals(this.mButtonNames[1])) {
            this.mCancel = true;
            this.dispose();
        }
    }

    public boolean wasCancelled() {
        return this.mCancel;
    }

    public boolean isIntegrityEnabled() {
        return this.mIsIntegrityEnabled;
    }

    public boolean isPrivacyEnabled() {
        return this.mIsPrivacyEnabled;
    }

    public String getAuthenticationMechanism() {
        return this.mAuthenticationMechanism;
    }

    public String getDelegation() {
        return this.mDelegationLevel;
    }
}

