/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import uk.org.ogsadai.client.databrowser.DBDataResource;
import uk.org.ogsadai.client.databrowser.DBGUI;
import uk.org.ogsadai.client.databrowser.DBMessageLevelSecuritySettingsDialog;
import uk.org.ogsadai.client.databrowser.DBModel;
import uk.org.ogsadai.client.databrowser.DBProgressModel;
import uk.org.ogsadai.client.databrowser.GUIThread;
import uk.org.ogsadai.client.databrowser.sql.DBJoinDialog;
import uk.org.ogsadai.client.databrowser.sql.DBJoinParameter;
import uk.org.ogsadai.client.databrowser.sql.DBResultSetView;
import uk.org.ogsadai.client.databrowser.sql.DBSchemaView;

public class DBMenuController {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2006.";
    private DBGUI mGUI;
    private DBModel mModel;
    private static final String ABOUT = "(c) EPCC, University of Edinburgh 2002 - 2006\nOriginally developed as part of the FirstDIG project\n";

    public DBMenuController(DBGUI gui, DBModel model) {
        this.mGUI = gui;
        this.mModel = model;
    }

    public void exit() {
        this.mGUI.exit();
    }

    public void about() {
        JOptionPane.showMessageDialog(this.mGUI, ABOUT, "About", -1);
    }

    public Component getParent() {
        return this.mGUI;
    }

    public void launchJoinDialog() {
        int size = this.mModel.getDataResourceIDs().size();
        if (size == 0) {
            JOptionPane.showMessageDialog(this.mGUI, "No databases currently available");
        } else {
            new DBJoinDialog(this.mGUI, this);
        }
    }

    public void runJoin(final DBJoinParameter parameters) {
        GUIThread thread = new GUIThread(){

            public Object setup() {
                DBResultSetView view = new DBResultSetView(DBMenuController.this.mModel, DBMenuController.this.mGUI);
                try {
                    DBMenuController.this.mModel.runJoin(new DBProgressModel(DBMenuController.this.mGUI), parameters);
                }
                catch (Exception e) {
                    view.stopObserving();
                    JOptionPane.showMessageDialog(DBMenuController.this.mGUI, "Join failed:" + e.getLocalizedMessage());
                    e.printStackTrace();
                }
                return null;
            }
        };
        thread.start();
    }

    public void retrieveSchema() {
        final DBDataResource service = this.mGUI.getDataServiceView().getSelectedDataResource();
        if (service == null) {
            JOptionPane.showMessageDialog(this.getParent(), "Please select a database");
            return;
        }
        final DBProgressModel pm = new DBProgressModel(this.mGUI);
        GUIThread thread = new GUIThread(){

            public Object setup() {
                DBSchemaView view = new DBSchemaView(DBMenuController.this.mModel, DBMenuController.this.mGUI);
                try {
                    pm.startTask("Retrieving the database schema");
                    DBMenuController.this.mModel.retrieveSchema(pm, service);
                }
                catch (Exception e) {
                    pm.finishTask();
                    view.stopObserving();
                    JOptionPane.showMessageDialog(DBMenuController.this.mGUI, "Error while retrieving schema:\n" + e.getLocalizedMessage());
                    e.printStackTrace();
                }
                pm.finishTask();
                return null;
            }
        };
        thread.start();
    }

    public void enableTransportLevelEncryption() {
        DBDataResource service = this.mGUI.getDataServiceView().getSelectedDataResource();
        if (service == null) {
            JOptionPane.showMessageDialog(this.getParent(), "Please select a database");
            return;
        }
        service.enableTransportLevelEncryption();
    }

    public void setMessageLevelSecurityDescriptor() {
        DBDataResource service = this.mGUI.getDataServiceView().getSelectedDataResource();
        if (service == null) {
            JOptionPane.showMessageDialog(this.getParent(), "Please select a database");
            return;
        }
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(this.mGUI);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            service.setMessageLevelSecurity(file);
        }
    }

    public void configureMessageLevelSecurityDescriptor() {
        DBDataResource service = this.mGUI.getDataServiceView().getSelectedDataResource();
        if (service == null) {
            JOptionPane.showMessageDialog(this.getParent(), "Please select a database");
            return;
        }
        DBMessageLevelSecuritySettingsDialog settings = new DBMessageLevelSecuritySettingsDialog(this.mGUI);
        if (settings.wasCancelled()) {
            return;
        }
        File descriptor = this.writeMLSDescriptor(settings.isPrivacyEnabled(), settings.isIntegrityEnabled(), settings.getAuthenticationMechanism(), settings.getDelegation());
        if (descriptor != null) {
            service.setMessageLevelSecurity(descriptor);
        }
    }

    private File writeMLSDescriptor(boolean privacy, boolean integrity, String auth, String delegation) {
        StringBuffer config = new StringBuffer();
        config.append("<securityConfig xmlns=\"http://www.globus.org\">\n");
        config.append("   <GSISecureConversation>\n");
        if (privacy) {
            config.append("      <privacy/>\n");
        }
        if (integrity) {
            config.append("      <integrity/>\n");
        }
        if (!"none".equals(delegation)) {
            config.append("      <delegation value=\"");
            config.append(delegation);
            config.append("\"/>\n");
        }
        config.append("   </GSISecureConversation>\n");
        config.append("   <authz value=\"");
        config.append(auth);
        config.append("\"/>\n");
        config.append("</securityConfig>");
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Please Select A Configuration File");
            int returnVal = chooser.showSaveDialog(this.mGUI);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                bw.write(config.toString());
                bw.close();
                return file;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

