/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import uk.org.ogsadai.client.databrowser.DBClient;
import uk.org.ogsadai.client.databrowser.DBDataServiceController;
import uk.org.ogsadai.client.databrowser.DBDataServiceView;
import uk.org.ogsadai.client.databrowser.DBMenuBar;
import uk.org.ogsadai.client.databrowser.DBMenuController;
import uk.org.ogsadai.client.databrowser.DBModel;
import uk.org.ogsadai.client.databrowser.DBRequestController;
import uk.org.ogsadai.client.databrowser.DBRequestPanel;

public class DBGUI
extends JFrame {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    public static final int HGAP = 5;
    public static final int VGAP = 5;
    public static final Dimension SCREENSIZE = Toolkit.getDefaultToolkit().getScreenSize();
    public static final Dimension MAX_COMBOBOX_SIZE = new Dimension(5000, 1);
    private static final int WIDTH = DBGUI.SCREENSIZE.width * 1 / 2;
    private static final int HEIGHT = DBGUI.SCREENSIZE.height * 1 / 2;
    private static final String NAME = "Data Service Browser - (c) 2002 - 2006 The University of Edinburgh";
    private DBModel mModel = new DBModel();
    private DBDataServiceView mDataServiceView = new DBDataServiceView(this.mModel);
    private DBRequestPanel mRequestPanel = new DBRequestPanel(this, this.mModel);
    private DBRequestController mRequestController = new DBRequestController(this.mRequestPanel);
    private DBDataServiceController mDataServiceController = new DBDataServiceController(this, this.mModel, this.mDataServiceView);
    private DBMenuController mMenuController = new DBMenuController(this, this.mModel);

    public DBGUI() {
        this.initialise();
        this.show();
    }

    private void initialise() {
        ImageIcon icon = DBGUI.createImageIcon("images/FirstLogo.GIF", "First PLC logo");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.setSize(new Dimension(WIDTH, HEIGHT));
        this.setTitle(NAME);
        this.setDefaultCloseOperation(0);
        this.initComponents();
        this.addWindowListener(new DBGUIListener());
        this.setLocation(Math.max(0, (DBGUI.SCREENSIZE.width - WIDTH) / 2), Math.max(0, (DBGUI.SCREENSIZE.height - HEIGHT) / 2));
    }

    public static ImageIcon createImageIcon(String path, String description) {
        URL imgURL = DBClient.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        return null;
    }

    private void initComponents() {
        this.setJMenuBar(new DBMenuBar(this.mMenuController));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridheight = 1;
        mainPanel.add((Component)this.mDataServiceView, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.anchor = 19;
        mainPanel.add((Component)this.mDataServiceController, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        mainPanel.add((Component)this.mRequestPanel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.fill = 2;
        constraints.anchor = 19;
        mainPanel.add((Component)this.mRequestController, constraints);
        this.getContentPane().add(mainPanel);
    }

    public void exit() {
        if (JOptionPane.showConfirmDialog(this, "Press OK to exit program", "Exit", 2) == 0) {
            System.exit(0);
        }
    }

    public DBDataServiceView getDataServiceView() {
        return this.mDataServiceView;
    }

    private class DBGUIListener
    extends WindowAdapter {
        private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";

        private DBGUIListener() {
        }

        public void windowClosing(WindowEvent e) {
            DBGUI.this.exit();
        }

        public void windowGainedFocus(WindowEvent e) {
            DBGUI.this.toFront();
        }
    }
}

