/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import uk.org.ogsadai.client.databrowser.DBClient;
import uk.org.ogsadai.client.databrowser.DBDataResource;
import uk.org.ogsadai.client.databrowser.DBDataService;
import uk.org.ogsadai.client.databrowser.DBModel;
import uk.org.ogsadai.client.databrowser.DataServiceTreeCellRenderer;

public class DBDataServiceView
extends JPanel
implements Observer,
TreeSelectionListener {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final String DATA_SERVICES_HISTORY_FILE = "DBClient_daiservices.properties";
    private static final int NUM_VISIBLE_ROWS = 3;
    private JTree mActiveTree;
    private Vector mHistoryList = new Vector();
    private DataServiceViewObservable mObservable = new DataServiceViewObservable();

    public DBDataServiceView(Observable model) {
        model.addObserver(this);
        this.loadDataServices();
        this.initialise();
    }

    private void loadDataServices() {
        String line = "";
        Vector<String> items = new Vector<String>();
        FileReader in = null;
        try {
            File inFile = new File(DATA_SERVICES_HISTORY_FILE);
            if (inFile.exists()) {
                in = new FileReader(inFile);
                BufferedReader input = new BufferedReader(in);
                while ((line = input.readLine()) != null) {
                    items.addElement(line);
                }
                in.close();
            }
            this.mHistoryList = items;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveDataServices() {
        try {
            FileWriter out = new FileWriter(new File(DATA_SERVICES_HISTORY_FILE));
            BufferedWriter output = new BufferedWriter(out);
            String line = "";
            for (int i = 0; i < this.mHistoryList.size(); ++i) {
                line = this.mHistoryList.get(i).toString();
                output.write(line + DBClient.NEWLINE);
            }
            output.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initialise() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Data Services");
        DefaultTreeModel treemodel = new DefaultTreeModel(node);
        this.mActiveTree = new JTree(treemodel);
        this.mActiveTree.setEditable(true);
        this.mActiveTree.getSelectionModel().setSelectionMode(1);
        this.mActiveTree.setRootVisible(false);
        this.mActiveTree.setShowsRootHandles(false);
        this.mActiveTree.setVisibleRowCount(10);
        this.mActiveTree.addTreeSelectionListener(this);
        this.mActiveTree.setVisible(true);
        this.mActiveTree.setCellRenderer(new DataServiceTreeCellRenderer());
        this.setBorder(BorderFactory.createTitledBorder("Data Services"));
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)new JScrollPane(this.mActiveTree), "Center");
    }

    public DBDataService getSelectedDataService() {
        TreePath path = this.mActiveTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node.getUserObject() instanceof DBDataService) {
            DBDataService service = (DBDataService)node.getUserObject();
            return service;
        }
        return null;
    }

    public DBDataResource getSelectedDataResource() {
        TreePath path = this.mActiveTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node.getUserObject() instanceof DBDataResource) {
            DBDataResource resource = (DBDataResource)node.getUserObject();
            return resource;
        }
        return null;
    }

    public void update(Observable observable, Object updatedObject) {
        if (updatedObject instanceof Vector) {
            DBModel model = (DBModel)observable;
            Vector services = model.getDataServices();
            this.mActiveTree.removeAll();
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("Data Services");
            DefaultTreeModel treemodel = new DefaultTreeModel(root);
            this.mActiveTree.setModel(treemodel);
            for (int i = 0; i < services.size(); ++i) {
                DBDataService service = (DBDataService)services.elementAt(i);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(service);
                treemodel.insertNodeInto(node, root, i);
                DBDataResource[] resources = service.getDataResources();
                for (int j = 0; j < resources.length; ++j) {
                    DefaultMutableTreeNode res = new DefaultMutableTreeNode(resources[j]);
                    treemodel.insertNodeInto(res, node, j);
                    TreePath path = new TreePath(new Object[]{root, node, res});
                    this.mActiveTree.makeVisible(path);
                }
            }
            this.mActiveTree.revalidate();
            this.mActiveTree.setVisible(true);
            this.mActiveTree.setRootVisible(true);
            this.compare();
        }
    }

    private void compare() {
        int numItems = this.mHistoryList.size();
        String url = "";
        if (numItems > 0) {
            for (int j = 0; j < this.mActiveTree.getModel().getChildCount(this.mActiveTree.getModel().getRoot()); ++j) {
                int i;
                url = this.mActiveTree.getModel().getChild(this.mActiveTree.getModel().getRoot(), i).toString();
                for (i = 0; i < numItems && !this.mHistoryList.get(i).toString().equals(url); ++i) {
                }
                if (i != numItems) continue;
                this.mHistoryList.addElement(url);
            }
        } else {
            for (int j = 0; j < this.mActiveTree.getModel().getChildCount(this.mActiveTree.getModel().getRoot()); ++j) {
                url = this.mActiveTree.getModel().getChild(this.mActiveTree.getModel().getRoot(), j).toString();
                this.mHistoryList.addElement(url);
            }
        }
        this.saveDataServices();
    }

    public Vector getURLs() {
        return this.mHistoryList;
    }

    public DBDataService[] getDataServices() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.mActiveTree.getModel().getRoot();
        DBDataService[] services = new DBDataService[root.getChildCount()];
        for (int i = 0; i < services.length; ++i) {
            services[i] = (DBDataService)((DefaultMutableTreeNode)root.getChildAt(i)).getUserObject();
        }
        return services;
    }

    public void addObserver(Observer observer) {
        this.mObservable.addObserver(observer);
    }

    public void valueChanged(TreeSelectionEvent event) {
        if (event.getNewLeadSelectionPath() != null) {
            DefaultMutableTreeNode last = (DefaultMutableTreeNode)event.getNewLeadSelectionPath().getLastPathComponent();
            this.mObservable.updateObservers(last.getUserObject());
        } else {
            this.mObservable.updateObservers(null);
        }
    }

    private class DataServiceViewObservable
    extends Observable {
        private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";

        private DataServiceViewObservable() {
        }

        public void updateObservers(Object obj) {
            this.setChanged();
            this.notifyObservers(obj);
        }
    }
}

