/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import uk.org.ogsadai.client.databrowser.DBDataServiceController;
import uk.org.ogsadai.client.databrowser.DBGUI;

public class DBDataServiceSelectorDialog
extends JDialog
implements ActionListener {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final String TITLE = "Select Data Service";
    private static final boolean MODAL = true;
    private static final String DEFAULT_URL = "http://localhost:8080/wsrf/services/ogsadai/DataService";
    private DBDataServiceController mController;
    private JTextArea mTextInput = new JTextArea();
    private String[] mButtonNames = new String[]{"OK", "Cancel"};

    public DBDataServiceSelectorDialog(DBGUI parent, DBDataServiceController controller, Vector oldURLs) {
        super(parent, TITLE, true);
        this.mController = controller;
        this.initComponents(oldURLs);
        this.setLocationRelativeTo(parent);
        this.pack();
        this.show();
    }

    private void initComponents(Vector oldURLs) {
        this.mTextInput.setText(DEFAULT_URL);
        this.mTextInput.setColumns(DEFAULT_URL.length() + 40);
        this.mTextInput.setBorder(BorderFactory.createEtchedBorder());
        this.mTextInput.setAlignmentX(0.0f);
        this.mTextInput.setMaximumSize(DBGUI.MAX_COMBOBOX_SIZE);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        buttonPanel.setAlignmentX(0.0f);
        for (int i = 0; i < this.mButtonNames.length; ++i) {
            JButton button = new JButton(this.mButtonNames[i]);
            button.addActionListener(this);
            button.setActionCommand(this.mButtonNames[i]);
            buttonPanel.add(button);
        }
        final JComboBox previousList = new JComboBox(oldURLs);
        previousList.setMaximumSize(DBGUI.MAX_COMBOBOX_SIZE);
        previousList.setAlignmentX(0.0f);
        previousList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DBDataServiceSelectorDialog.this.mTextInput.setText((String)previousList.getSelectedItem());
            }
        });
        JLabel label1 = new JLabel("Enter the data service URL:");
        JLabel label2 = new JLabel("... or select a previously accessed data service");
        label1.setAlignmentX(0.0f);
        label2.setAlignmentX(0.0f);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(Box.createVerticalGlue());
        panel.add(label1);
        panel.add(this.mTextInput);
        panel.add(Box.createVerticalGlue());
        panel.add(label2);
        panel.add(previousList);
        panel.add(Box.createVerticalGlue());
        panel.add(buttonPanel);
        panel.add(Box.createVerticalGlue());
        this.getContentPane().add(panel);
        this.mTextInput.grabFocus();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(this.mButtonNames[0])) {
            String text = this.mTextInput.getText();
            if (!text.equals("")) {
                this.hide();
                this.mController.doAddDataService(this.mTextInput.getText());
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this.getParent(), "Please enter a URL for the data service", "Data service entry", 1);
            }
        } else if (command.equals(this.mButtonNames[1])) {
            this.dispose();
        }
    }
}

