/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import uk.org.ogsadai.client.databrowser.DBDataService;
import uk.org.ogsadai.client.databrowser.DBDataServiceSelectorDialog;
import uk.org.ogsadai.client.databrowser.DBDataServiceView;
import uk.org.ogsadai.client.databrowser.DBGUI;
import uk.org.ogsadai.client.databrowser.DBModel;
import uk.org.ogsadai.client.databrowser.DBProgressModel;
import uk.org.ogsadai.client.databrowser.GUIThread;

public class DBDataServiceController
extends JPanel
implements ActionListener {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private DBGUI mGUI;
    private DBModel mModel;
    private DBDataServiceView mDataServiceView;
    private String[] mButtonNames = new String[]{"Add Data Service ...", "Remove Data Service"};

    public DBDataServiceController(DBGUI gui, DBModel model, DBDataServiceView dsView) {
        this.mGUI = gui;
        this.mModel = model;
        this.mDataServiceView = dsView;
        this.setLayout(new GridLayout(this.mButtonNames.length, 1, 5, 5));
        if (this.mButtonNames != null) {
            for (int i = 0; i < this.mButtonNames.length; ++i) {
                JButton button = new JButton(this.mButtonNames[i]);
                button.addActionListener(this);
                button.setActionCommand(this.mButtonNames[i]);
                this.add(button);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(this.mButtonNames[0])) {
            this.addDataService();
        } else if (command.equals(this.mButtonNames[1])) {
            this.removeDataService();
        }
    }

    private void removeDataService() {
        DBDataService selected = this.mDataServiceView.getSelectedDataService();
        if (selected != null) {
            this.mModel.removeDataService(selected);
        } else {
            JOptionPane.showMessageDialog(this.getParent(), "Please select a data service");
        }
    }

    private void addDataService() {
        new DBDataServiceSelectorDialog(this.mGUI, this, this.mDataServiceView.getURLs());
    }

    public void doAddDataService(final String url) {
        GUIThread thread = new GUIThread(){

            public Object setup() {
                try {
                    DBDataServiceController.this.mModel.addDataService(url, new DBProgressModel(DBDataServiceController.this.mGUI));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(DBDataServiceController.this.mGUI, "The URL entered is not valid\n" + e.getLocalizedMessage(), "Error", 0);
                    e.printStackTrace();
                }
                return null;
            }
        };
        thread.start();
    }
}

