/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.net.URL;
import uk.org.ogsadai.client.databrowser.DBDataResource;
import uk.org.ogsadai.client.databrowser.DBProgressModel;
import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.service.DataService;

public class DBDataService {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private DBDataResource[] mDataResources;
    private int mNumResources;
    private URL mDataServiceURL;
    private DataService mDataService;

    public DBDataService(String handle, DBProgressModel pm) throws Exception {
        pm.startTask("Adding a Data Service", 3);
        try {
            pm.status("Fetching the data service");
            this.mDataService = GenericServiceFetcher.getInstance().getDataService(handle, null);
            this.mDataServiceURL = this.mDataService.getURL();
            pm.status("Getting the data resources");
            ResourceID[] resources = this.mDataService.getResourceIDs();
            this.mNumResources = resources.length;
            if (this.mNumResources > 0) {
                this.mDataResources = new DBDataResource[this.mNumResources];
                pm.status("Listing the data resources");
                for (int i = 0; i < this.mNumResources; ++i) {
                    this.mDataResources[i] = new DBDataResource(this, resources[i]);
                }
            } else {
                this.mDataResources = null;
            }
        }
        catch (Exception e) {
            pm.finishTask();
            e.printStackTrace();
            throw new Exception("Failed adding data service:\nURL:" + this.mDataServiceURL + "\n" + "Error message:" + e.getLocalizedMessage());
        }
        pm.finishTask();
    }

    public DBDataResource[] getDataResources() {
        return this.mDataResources;
    }

    public int getNumResources() {
        return this.mNumResources;
    }

    public URL getDataServiceURL() {
        return this.mDataServiceURL;
    }

    public String toString() {
        return this.mDataServiceURL.toString();
    }
}

