/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Vector;
import uk.org.ogsadai.client.CoGUtil;
import uk.org.ogsadai.client.databrowser.DBDataService;
import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.TimeoutProperty;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.activity.relational.DatabaseSchemaToXML;
import uk.org.ogsadai.client.toolkit.activity.relational.ExtractDatabaseSchema;
import uk.org.ogsadai.client.toolkit.security.wsrf.GSITransportEncryptionProperty;
import uk.org.ogsadai.client.toolkit.security.wsrf.SecurityConfigProperty;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.converters.databaseschema.DatabaseSchemaMetaData;

public class DBDataResource {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2006.";
    private DBDataService mDataService;
    private ResourceID mResourceID;
    private DataService mService;
    private Vector mSupportedActivities = null;
    private boolean mMLSEnabled = false;
    private boolean mTLSEncryptionEnabled = false;

    public DBDataResource(DBDataService service, ResourceID resourceID) throws Exception {
        this.mDataService = service;
        this.mResourceID = resourceID;
        try {
            this.mService = GenericServiceFetcher.getInstance().getDataService(this.mDataService.getDataServiceURL().toString(), null);
            this.mService.setResourceID(resourceID);
            this.getSupportedActivities();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public ResourceID getResourceID() {
        return this.mResourceID;
    }

    public DBDataService getDataService() {
        return this.mDataService;
    }

    public void setTimeOut(int milliseconds) {
        this.mService.setConnectionProperty(new TimeoutProperty(milliseconds));
    }

    public void setMessageLevelSecurity(File descriptor) {
        SecurityConfigProperty securityProperty = new SecurityConfigProperty(descriptor);
        this.mService.setConnectionProperty(securityProperty);
        this.mMLSEnabled = true;
    }

    public void enableTransportLevelEncryption() {
        if (!CoGUtil.isRegistered()) {
            System.out.println(CoGUtil.getRegistrationException().getLocalizedMessage());
            return;
        }
        this.mService.setConnectionProperty(new GSITransportEncryptionProperty());
        this.mTLSEncryptionEnabled = true;
    }

    public Vector getSupportedActivities() {
        if (this.mSupportedActivities == null) {
            try {
                String[] activities = this.mService.getSupportedActivities();
                this.mSupportedActivities = new Vector(activities.length);
                for (int i = 0; i < activities.length; ++i) {
                    this.mSupportedActivities.add(activities[i]);
                }
            }
            catch (Exception e) {
                System.out.print("Exception while retrieving supported activities: ");
                e.printStackTrace();
            }
        }
        return this.mSupportedActivities;
    }

    public boolean isSQLQuerySupported() {
        if (this.mSupportedActivities == null) {
            this.getSupportedActivities();
        }
        return this.mSupportedActivities.contains("sqlQueryStatement");
    }

    public boolean isSQLUpdateSupported() {
        if (this.mSupportedActivities == null) {
            this.getSupportedActivities();
        }
        return this.mSupportedActivities.contains("sqlUpdateStatement");
    }

    public boolean isXPathQuerySupported() {
        if (this.mSupportedActivities == null) {
            this.getSupportedActivities();
        }
        return this.mSupportedActivities.contains("xPathStatement");
    }

    public DatabaseSchemaMetaData getDatabaseSchema() throws Exception {
        try {
            ActivityRequest request = new ActivityRequest();
            ExtractDatabaseSchema extractSchema = new ExtractDatabaseSchema();
            DatabaseSchemaToXML convertSchema = new DatabaseSchemaToXML(extractSchema.getOutput());
            request.add(extractSchema);
            request.add(convertSchema);
            this.mService.perform(request);
            DatabaseSchemaMetaData schema = convertSchema.getAsDatabaseSchemaMetaData();
            return schema;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Exception while retrieving database schema:\n" + e.getLocalizedMessage());
        }
    }

    public Response perform(RequestComponent component) throws Exception {
        return this.mService.perform(component);
    }

    public Response perform(ActivityRequest request) throws Exception {
        return this.mService.perform(request);
    }

    public String toString() {
        return this.mResourceID.getName();
    }

    public boolean isMLSEnabled() {
        return this.mMLSEnabled;
    }

    public boolean isTLSEncryptionEnabled() {
        return this.mTLSEncryptionEnabled;
    }
}

