/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.databrowser;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import uk.org.ogsadai.client.databrowser.DBMenuController;

public abstract class DBAbstractMenu
extends JMenu
implements ActionListener {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    protected DBMenuController mController = null;
    protected DBMenuItem[] mMenuItems = null;
    protected Component mParent = null;

    public DBAbstractMenu(DBMenuController controller) {
        this.mController = controller;
        this.mParent = this.mController.getParent();
        this.constructor();
    }

    public DBAbstractMenu() {
        this.constructor();
    }

    private void constructor() {
        this.initMenuItems();
        this.initMenu();
    }

    private void initMenu() {
        if (this.mMenuItems != null) {
            for (int i = 0; i < this.mMenuItems.length; ++i) {
                JMenuItem menuItem;
                switch (this.mMenuItems[i].mType) {
                    case 2: {
                        menuItem = new JCheckBoxMenuItem(this.mMenuItems[i].mName, this.mMenuItems[i].mState);
                        break;
                    }
                    case 1: {
                        menuItem = new JRadioButtonMenuItem(this.mMenuItems[i].mName);
                        break;
                    }
                    default: {
                        menuItem = new JMenuItem(this.mMenuItems[i].mName);
                    }
                }
                menuItem.addActionListener(this);
                menuItem.setActionCommand(this.mMenuItems[i].mName);
                this.add(menuItem);
                this.mMenuItems[i].mMenuItem = menuItem;
            }
        }
    }

    protected abstract void initMenuItems();

    public abstract void actionPerformed(ActionEvent var1);

    protected class DBMenuItem {
        private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
        protected String mName;
        protected int mType;
        protected JMenuItem mMenuItem = null;
        protected boolean mState = false;
        protected static final int STANDARD = 0;
        protected static final int RADIO = 1;
        protected static final int CHECKBOX = 2;

        public DBMenuItem(String name) {
            this.mType = 0;
            this.mName = name;
        }

        public DBMenuItem(String name, int type) {
            if (type > 2 || type < 0) {
                type = 0;
            }
            this.mType = type;
            this.mName = name;
        }

        public DBMenuItem(String name, int type, boolean state) {
            if (type > 2 || type < 0) {
                type = 0;
            }
            this.mType = type;
            this.mName = name;
            this.mState = state;
        }

        public String getName() {
            return this.mName;
        }
    }
}

