/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import uk.org.ogsadai.client.CoGUtilAccessException;
import uk.org.ogsadai.exception.DAIClassCreateException;
import uk.org.ogsadai.exception.DAIClassNotFoundException;
import uk.org.ogsadai.exception.DAIMethodInvocationException;

public class CoGUtil {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2006.";
    private static final String CLASS_NAME = "org.globus.axis.util.Util";
    private static final String METHOD_NAME = "registerTransport";
    private static final Class[] PARAM_TYPES = new Class[0];
    private static boolean mRegistrationAttempted = false;
    private static boolean mRegistrationSuccessfull = false;
    private static CoGUtilAccessException mRegistrationException = null;

    public static void registerTransport() {
        if (mRegistrationAttempted) {
            return;
        }
        mRegistrationAttempted = true;
        try {
            Class<?> classDef = Class.forName(CLASS_NAME);
            Method registerMethod = classDef.getMethod(METHOD_NAME, PARAM_TYPES);
            Object[] args = new Object[]{};
            registerMethod.invoke(null, args);
            mRegistrationSuccessfull = true;
        }
        catch (ClassNotFoundException e) {
            DAIClassNotFoundException ex = new DAIClassNotFoundException(CLASS_NAME);
            mRegistrationException = new CoGUtilAccessException(ex);
        }
        catch (IllegalAccessException e) {
            DAIClassCreateException ex = new DAIClassCreateException(CLASS_NAME, e);
            mRegistrationException = new CoGUtilAccessException(ex);
        }
        catch (NoSuchMethodException e) {
            DAIMethodInvocationException ex = new DAIMethodInvocationException(CLASS_NAME, METHOD_NAME, PARAM_TYPES);
            mRegistrationException = new CoGUtilAccessException(ex);
        }
        catch (InvocationTargetException e) {
            DAIMethodInvocationException ex = new DAIMethodInvocationException(CLASS_NAME, METHOD_NAME, PARAM_TYPES);
            mRegistrationException = new CoGUtilAccessException(ex);
        }
    }

    public static boolean isRegistered() {
        return mRegistrationSuccessfull;
    }

    public static CoGUtilAccessException getRegistrationException() {
        return mRegistrationException;
    }

    static {
        CoGUtil.registerTransport();
    }
}

