/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client;

import java.io.File;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.org.ogsadai.client.CoGUtil;
import uk.org.ogsadai.client.toolkit.DocumentRequest;
import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.SimpleResourceIDImpl;
import uk.org.ogsadai.client.toolkit.properties.DAIVersion;
import uk.org.ogsadai.client.toolkit.properties.Property;
import uk.org.ogsadai.client.toolkit.security.SecurityProperty;
import uk.org.ogsadai.client.toolkit.security.wsrf.GSITransportEncryptionProperty;
import uk.org.ogsadai.client.toolkit.security.wsrf.SecurityConfigProperty;
import uk.org.ogsadai.client.toolkit.service.ConfigurableDataService;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class Client {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corporation 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static String mURL = "http://localhost:8080/wsrf/services/ogsadai/DataService";
    private static String mID = null;
    private static String mAction = null;
    private static String mProperty = null;
    private static boolean mApplyMessageLevelSecurity = false;
    private static String mClientSecurityDescriptor;
    private static boolean mApplyTransportLevelSecurity;
    private static boolean mApplyTransportLevelEncryption;

    public static void main(String[] args) {
        Client.parse(args);
        try {
            SecurityProperty securityProperty;
            if (mApplyMessageLevelSecurity) {
                System.out.println("Using message level security with descriptor: " + mClientSecurityDescriptor);
            }
            if (mApplyTransportLevelSecurity) {
                if (!CoGUtil.isRegistered()) {
                    Client.exitClient(CoGUtil.getRegistrationException());
                }
                System.out.println("Using transport level security with " + (mApplyTransportLevelEncryption ? "" : "no ") + "encryption");
            }
            GenericServiceFetcher fetcher = GenericServiceFetcher.getInstance();
            ConfigurableDataService service = fetcher.getConfigurableDataService(mURL, null);
            if (mApplyMessageLevelSecurity) {
                securityProperty = new SecurityConfigProperty(new File(mClientSecurityDescriptor));
                service.setConnectionProperty(securityProperty);
            } else if (mApplyTransportLevelEncryption) {
                securityProperty = new GSITransportEncryptionProperty();
                service.setConnectionProperty(securityProperty);
            }
            DAIVersion version = service.getVersion();
            System.out.println("Service version: " + version.toString());
            ResourceID[] resources = service.getResourceIDs();
            if (resources == null) {
                System.out.println("This service exposes no resources!");
            } else {
                int numResources = resources.length;
                System.out.println("Number of resources: " + numResources);
                for (int i = 0; i < numResources; ++i) {
                    System.out.println("Resource: " + resources[i].getName());
                }
            }
            if (mAction == null) {
                System.exit(0);
            }
            System.out.println("Data Service Resource: " + mID);
            if (mAction.equals("deploy")) {
                System.out.println("About to invoke Deploy...");
                service.deploy(mID);
                System.out.println("Deploy completed!");
            } else if (mAction.equals("undeploy")) {
                System.out.println("About to invoke Undeploy...");
                service.undeploy(mID);
                System.out.println("Undeploy completed!");
            } else {
                SimpleResourceIDImpl id = new SimpleResourceIDImpl(mID);
                service.setResourceID(id);
                if (mAction.equals("getProperty")) {
                    String[] propertyNames = mProperty.split("_");
                    if (propertyNames.length == 1) {
                        Property property = Client.getProperty(service, propertyNames[0]);
                        Client.displayProperty(property);
                    } else {
                        Property[] properties = Client.getProperties(service, propertyNames);
                        int numProperties = properties.length;
                        for (int i = 0; i < numProperties; ++i) {
                            Client.displayProperty(properties[i]);
                        }
                    }
                } else if (mAction.equals("terminate")) {
                    System.out.println("About to invoke terminate...");
                    service.terminate();
                    System.out.println("Terminate completed!");
                } else {
                    Document performDoc = Client.loadPerformDoc();
                    DocumentRequest request = new DocumentRequest(performDoc);
                    System.out.println("About to invoke Perform...");
                    Response response = service.perform(request);
                    System.out.println("Perform completed!");
                    System.out.println("Response: ");
                    System.out.println(response.getAsString());
                }
            }
        }
        catch (Exception e) {
            Client.exitClient(e);
        }
    }

    private static Property getProperty(ConfigurableDataService service, String property) throws Exception {
        return service.getProperty(QName.valueOf(property));
    }

    private static Property[] getProperties(ConfigurableDataService service, String[] properties) throws Exception {
        int numProperties = properties.length;
        QName[] names = new QName[numProperties];
        for (int i = 0; i < numProperties; ++i) {
            names[i] = QName.valueOf(properties[i]);
        }
        return service.getProperties(names);
    }

    private static void displayProperty(Property property) {
        System.out.println("Property name: " + property.getName());
        Object value = property.getValue();
        if (value instanceof Element[]) {
            Element[] elts = (Element[])value;
            int numElts = elts.length;
            for (int i = 0; i < numElts; ++i) {
                String valueStr = XMLUtilities.xmlDOMToString(elts[i]);
                System.out.println("Value " + (i + 1) + ":\n" + valueStr);
            }
        } else {
            String valueStr = XMLUtilities.xmlDOMToString((Element)value);
            System.out.println("Value:\n" + valueStr);
        }
    }

    private static void parse(String[] args) {
        int numArgs = args.length;
        if (numArgs == 0) {
            Client.displaySyntax();
            System.exit(0);
        }
        boolean isAwaitingAction = false;
        try {
            for (int arg = 0; arg < numArgs; ++arg) {
                if (args[arg].equals("-u")) {
                    mURL = args[++arg];
                    continue;
                }
                if (args[arg].equals("-k")) {
                    mID = args[++arg];
                    isAwaitingAction = true;
                    continue;
                }
                if (args[arg].equals("-mls")) {
                    mApplyMessageLevelSecurity = true;
                    mClientSecurityDescriptor = args[++arg];
                    continue;
                }
                if (args[arg].equals("-tls")) {
                    mApplyTransportLevelSecurity = true;
                    if (arg + 1 >= numArgs || !args[arg + 1].equals("encrypt")) continue;
                    mApplyTransportLevelEncryption = true;
                    ++arg;
                    continue;
                }
                if (isAwaitingAction) {
                    mAction = args[arg];
                    if (mAction.equals("getProperty")) {
                        mProperty = args[++arg];
                    }
                    isAwaitingAction = false;
                    continue;
                }
                System.out.println("A problem was encountered in processing your arguments!");
                Client.displaySyntax();
                System.exit(1);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("A problem was encountered in processing your arguments!");
            Client.displaySyntax();
            System.exit(1);
        }
    }

    private static void displaySyntax() {
        System.out.println("java uk.org.ogsadai.client.Client");
        System.out.println("  -u DATA-SERVICE-URI");
        System.out.println("  [-k DATA-SERVICE-RESOURCE-ID [PERFORM-DOCUMENT-FILE | deploy | undeploy | terminate | getProperty PROPERTY-NAME[_PROPERTY-NAME] ] ] ");
        System.out.println("  [-mls CLIENT_SECURITY_DESCRIPTOR]");
        System.out.println("  [-tls [encrypt]]");
    }

    public static void exitClient(Throwable e) {
        for (Throwable child = e; child != null; child = child.getCause()) {
            System.err.println(child.getLocalizedMessage());
        }
        System.exit(1);
    }

    private static Document loadPerformDoc() {
        Document doc = null;
        try {
            doc = XMLUtilities.xmlFileToDOM(mAction, false);
        }
        catch (Exception e) {
            Client.exitClient(e);
        }
        return doc;
    }

    static {
        mApplyTransportLevelSecurity = false;
        mApplyTransportLevelEncryption = false;
        CoGUtil.registerTransport();
    }
}

