/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.UnsupportedActivityException;
import uk.org.ogsadai.common.DocumentValidationException;
import uk.org.ogsadai.common.DocumentValidator;
import uk.org.ogsadai.common.msgs.DAILogger;

public class UnknownActivityDocumentValidator
extends DocumentValidator {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(UnknownActivityDocumentValidator.class);
    private final Set mKnownActivities;

    public UnknownActivityDocumentValidator(Set knownActivities) {
        this.mKnownActivities = knownActivities;
    }

    protected void performValidation(Document request) throws DocumentValidationException {
        Element root = request.getDocumentElement();
        this.validateChildren(root);
    }

    private void validateChildren(Node parent) throws DocumentValidationException {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            String name = ((Element)child).getLocalName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validating element named: " + name);
            }
            if (name.equals("sequence") || name.equals("flow")) {
                this.validateChildren(child);
                continue;
            }
            if (this.mKnownActivities.contains(name) || name.equals("documentation") || name.equals("session")) continue;
            throw new DocumentValidationException(new UnsupportedActivityException(name));
        }
    }
}

