/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.engine.Pipe;

public class SynchronizedGrowablePipe
implements Pipe {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(SynchronizedGrowablePipe.class);
    private final List mData = new Vector();
    private boolean mClosed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        if (this.hasNext()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting block");
            }
            SynchronizedGrowablePipe synchronizedGrowablePipe = this;
            synchronized (synchronizedGrowablePipe) {
                return this.mData.remove(0);
            }
        }
        throw new NoSuchElementException("There are no more blocks!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing pipe.");
        }
        SynchronizedGrowablePipe synchronizedGrowablePipe = this;
        synchronized (synchronizedGrowablePipe) {
            this.mClosed = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object block) {
        if (block == null) {
            throw new IllegalArgumentException("block must not be null");
        }
        if (this.mClosed) {
            throw new IllegalStateException("put must not be invoked after the pipe is closed");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding block: " + block);
        }
        SynchronizedGrowablePipe synchronizedGrowablePipe = this;
        synchronized (synchronizedGrowablePipe) {
            this.mData.add(block);
            this.notifyAll();
        }
    }

    public synchronized boolean hasNext() {
        if (this.mData.size() == 0) {
            this.waitForBlock();
        }
        return this.mData.size() > 0;
    }

    public synchronized void waitForBlock() {
        while (this.mData.size() == 0 && !this.mClosed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized boolean isOpen() {
        return !this.mClosed;
    }
}

