/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import uk.org.ogsadai.activity.PipeAccessException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.engine.Pipe;
import uk.org.ogsadai.engine.ProcessingStatus;

public class SynchronizedGrowableExternalPipe
implements Pipe {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(SynchronizedGrowableExternalPipe.class);
    private final List mData = new Vector();
    private boolean mClosed = false;
    private ProcessingStatus mStatus;

    public SynchronizedGrowableExternalPipe(ProcessingStatus status) {
        this.mStatus = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        if (this.hasNext()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting block");
            }
            SynchronizedGrowableExternalPipe synchronizedGrowableExternalPipe = this;
            synchronized (synchronizedGrowableExternalPipe) {
                return this.mData.remove(0);
            }
        }
        throw new NoSuchElementException("There are no more blocks!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOG.debug("Closing pipe.");
        SynchronizedGrowableExternalPipe synchronizedGrowableExternalPipe = this;
        synchronized (synchronizedGrowableExternalPipe) {
            this.mClosed = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object block) {
        if (block == null) {
            throw new IllegalArgumentException("Blocks must not be null");
        }
        if (this.mClosed) {
            throw new IllegalStateException("The put method must not be invoked after the pipe has been closed.");
        }
        if (this.mStatus.isProcessing()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding block: " + block);
            }
            SynchronizedGrowableExternalPipe synchronizedGrowableExternalPipe = this;
            synchronized (synchronizedGrowableExternalPipe) {
                this.mData.add(block);
                this.notifyAll();
            }
        } else {
            throw new PipeAccessException(this.mStatus);
        }
    }

    public synchronized boolean hasNext() {
        if (this.mData.size() == 0) {
            this.waitForBlock();
        }
        return this.mData.size() > 0;
    }

    public synchronized void waitForBlock() {
        while (this.mData.size() == 0 && !this.mClosed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized boolean isOpen() {
        return !this.mClosed;
    }
}

