/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import org.w3c.dom.Document;
import uk.org.ogsadai.common.DocumentValidationException;
import uk.org.ogsadai.common.DocumentValidator;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLSchemaUtilities;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIException;

public class SchemaDocumentValidator
extends DocumentValidator {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(SchemaDocumentValidator.class);
    private final Document mSchema;

    public SchemaDocumentValidator(Document schema) {
        if (schema == null) {
            throw new IllegalArgumentException("The 'schema' parameter must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating SchemaDocumentValidator for the following schema:\n" + XMLUtilities.xmlDOMToString(schema));
        }
        this.mSchema = schema;
    }

    protected void performValidation(Document request) throws DocumentValidationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing schema-validation of perform document...");
        }
        try {
            XMLSchemaUtilities.validate(request, this.mSchema);
        }
        catch (DAIException e) {
            throw new DocumentValidationException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Perform document schema-validation successful");
        }
    }
}

