/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.w3c.dom.Node;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.BufferDataForResponseException;
import uk.org.ogsadai.common.Base64;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.MemoryUtilities;
import uk.org.ogsadai.common.OutOfMemoryException;
import uk.org.ogsadai.common.UnsupportedBlockException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIIOException;

class ResultActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(ResultActivity.class);
    private final BlockReader mInput;
    private final StringBuffer mBuffer = new StringBuffer();
    private final ByteArrayOutputStream mByteArrayOutputStream = new ByteArrayOutputStream();

    ResultActivity(String name, BlockReader input) {
        super(name);
        this.mInput = input;
    }

    public void processBlock() {
        block11: {
            if (this.mInput.hasNext()) {
                MemoryUtilities.logMemoryUsage(LOG);
                try {
                    Object block = this.mInput.next();
                    if (block instanceof String) {
                        MemoryUtilities.checkMemory((String)block, LOG);
                        this.mBuffer.append((String)block);
                        break block11;
                    }
                    if (block instanceof Node) {
                        String nodeData = XMLUtilities.xmlDOMToString((Node)block);
                        MemoryUtilities.checkMemory(nodeData, LOG);
                        this.mBuffer.append(nodeData);
                        break block11;
                    }
                    if (block instanceof byte[]) {
                        MemoryUtilities.checkMemory((byte[])block, LOG);
                        try {
                            this.mByteArrayOutputStream.write((byte[])block);
                            this.mByteArrayOutputStream.flush();
                            break block11;
                        }
                        catch (IOException e) {
                            throw new BufferDataForResponseException(new DAIIOException(e));
                        }
                    }
                    throw new UnsupportedBlockException(block.getClass().getName());
                }
                catch (OutOfMemoryException e) {
                    this.setError(new ActivityExecutionException(this.getName(), e));
                }
                catch (BufferDataForResponseException e) {
                    this.setError(new ActivityExecutionException(this.getName(), e));
                }
                catch (UnsupportedBlockException e) {
                    this.setError(new ActivitySpecificationException(this.getName(), e));
                }
            } else {
                this.setCompleted();
            }
        }
    }

    public final byte[] getResultData() {
        if (this.mByteArrayOutputStream.size() > 0) {
            return new Base64().encode(this.mByteArrayOutputStream.toByteArray());
        }
        return this.mBuffer.toString().getBytes();
    }
}

