/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityAuthorizationException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.engine.ProcessingState;
import uk.org.ogsadai.engine.ProcessingStatus;
import uk.org.ogsadai.engine.ResponseBuilder;
import uk.org.ogsadai.engine.Status;
import uk.org.ogsadai.exception.AuthorisationFaultException;
import uk.org.ogsadai.exception.DAIAuthorizationException;
import uk.org.ogsadai.exception.DAIExceptionInformation;
import uk.org.ogsadai.exception.InternalFaultException;
import uk.org.ogsadai.exception.NonOGSADAIExceptionWrapper;
import uk.org.ogsadai.exception.ServerException;
import uk.org.ogsadai.sessions.Session;

public class ResponseDocumentBuilder
implements ResponseBuilder {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(ResponseDocumentBuilder.class);
    final Document mResponse = XMLUtilities.createEmptyDocument();
    final Element mRootElement = this.mResponse.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "response");

    public ResponseDocumentBuilder() {
        this.mResponse.appendChild(this.mRootElement);
        Element requestElement = this.mResponse.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "request");
        this.mRootElement.appendChild(requestElement);
        Element sessionElement = this.mResponse.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "session");
        this.mRootElement.insertBefore(sessionElement, requestElement);
    }

    public synchronized void buildResult(String name, ProcessingStatus status, byte[] data) {
        if (name == null || status == null) {
            throw new IllegalArgumentException("name and status must not be null");
        }
        Element result = this.mResponse.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "result");
        result.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/types", "name", name);
        result.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/types", "status", status.toString());
        if (data != null && data.length > 0) {
            result.appendChild(this.mResponse.createCDATASection(new String(data)));
        }
        this.mRootElement.appendChild(result);
    }

    public synchronized void buildResult(String name, Status status, byte[] data) {
        if (name == null || status == null) {
            throw new IllegalArgumentException("name and status must not be null");
        }
        Element result = this.mResponse.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "result");
        result.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/types", "name", name);
        result.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/types", "status", status.toString());
        if (data != null && data.length > 0) {
            result.appendChild(this.mResponse.createCDATASection(new String(data)));
        }
        this.mRootElement.appendChild(result);
    }

    public synchronized void buildError(String name, Throwable cause) {
        if (name == null || cause == null) {
            throw new IllegalArgumentException("name and cause must not be null");
        }
        Object message = null;
        Element result = this.mResponse.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "result");
        result.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/types", "name", name);
        result.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/types", "status", ProcessingState.ERROR.toString());
        if (cause instanceof ActivitySpecificationException || cause instanceof ActivityAuthorizationException) {
            this.addClientException(this.mResponse, result, cause);
        } else {
            this.addServerException(this.mResponse, result, cause);
        }
        this.mRootElement.appendChild(result);
    }

    public synchronized void buildRequestStatus(ProcessingStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("status must not be null");
        }
        NodeList nodes = this.mRootElement.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "request");
        Element requestElement = (Element)nodes.item(0);
        requestElement.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/types", "status", status.toString());
    }

    public synchronized void buildRequestError(String cause) {
        if (cause == null) {
            throw new IllegalArgumentException("cause must not be null");
        }
        NodeList nodes = this.mRootElement.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "request");
        Element requestElement = (Element)nodes.item(0);
        requestElement.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/types", "cause", cause);
        requestElement.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/types", "status", ProcessingState.ERROR.toString());
    }

    public void buildSessionDetails(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        NodeList nodes = this.mRootElement.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "session");
        Element element = (Element)nodes.item(0);
        element.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/types", "id", session.getID().toString());
    }

    public synchronized Document getResponseDocument() {
        return this.mResponse;
    }

    private void addClientException(Document doc, Element parent, Throwable exception) {
        LOG.warn(exception);
        Element fault = doc.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "activityFault");
        parent.appendChild(fault);
        for (Throwable cause = exception; cause != null; cause = cause.getCause()) {
            Element elt = doc.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "reason");
            fault.appendChild(elt);
            if (cause instanceof DAIAuthorizationException) {
                this.addClientExceptionAuthz(doc, elt, (DAIAuthorizationException)cause);
                break;
            }
            this.addClientExceptionDetail(doc, elt, cause);
        }
    }

    private void addClientExceptionDetail(Document doc, Element parent, Throwable exception) {
        DAIExceptionInformation daiEx = null;
        if (exception instanceof DAIExceptionInformation) {
            daiEx = (DAIExceptionInformation)((Object)exception);
        } else {
            NonOGSADAIExceptionWrapper wrapper = new NonOGSADAIExceptionWrapper(exception);
            daiEx = wrapper;
        }
        String errorID = daiEx.getErrorID().toString();
        Object[] params = daiEx.getParameters();
        String msg = daiEx.getLocalizedMessage();
        Element elt = this.mResponse.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "errorID");
        parent.appendChild(elt);
        elt.appendChild(this.mResponse.createTextNode(errorID));
        elt = this.mResponse.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "msg");
        parent.appendChild(elt);
        elt.appendChild(this.mResponse.createTextNode(msg));
        int numParams = 0;
        if (params != null) {
            numParams = params.length;
        }
        for (int i = 0; i < numParams; ++i) {
            elt = this.mResponse.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "params");
            parent.appendChild(elt);
            elt.appendChild(this.mResponse.createTextNode(params[i].toString()));
        }
    }

    private void addClientExceptionAuthz(Document doc, Element parent, DAIAuthorizationException exception) {
        AuthorisationFaultException authEx = new AuthorisationFaultException(exception);
        Element elt = doc.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "errorID");
        parent.appendChild(elt);
        elt.appendChild(doc.createTextNode(authEx.getErrorID().toString()));
        elt = doc.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "msg");
        parent.appendChild(elt);
        elt.appendChild(doc.createTextNode(authEx.getLocalizedMessage()));
        elt = doc.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "params");
        parent.appendChild(elt);
        elt.appendChild(doc.createTextNode(authEx.getParameters()[0].toString()));
    }

    private void addServerException(Document doc, Element parent, Throwable exception) {
        ServerException serverEx = new ServerException(exception);
        LOG.error(serverEx, true);
        InternalFaultException internalEx = new InternalFaultException(serverEx);
        Element fault = doc.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "activityFault");
        parent.appendChild(fault);
        Element reason = doc.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "reason");
        fault.appendChild(reason);
        Element elt = doc.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "errorID");
        reason.appendChild(elt);
        elt.appendChild(doc.createTextNode(internalEx.getErrorID().toString()));
        elt = doc.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "msg");
        reason.appendChild(elt);
        elt.appendChild(doc.createTextNode(internalEx.getLocalizedMessage()));
        elt = doc.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/types", "params");
        reason.appendChild(elt);
        elt.appendChild(doc.createTextNode(internalEx.getParameters()[0].toString()));
    }
}

