/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityExecutionException;

class RequestProcessor {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private final List mEndPoints;

    RequestProcessor(List endPoints) {
        this.mEndPoints = endPoints;
    }

    public void process() {
        if (this.mEndPoints.size() > 0) {
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (int i = 1; i < this.mEndPoints.size(); ++i) {
                final Activity activity = (Activity)this.mEndPoints.get(i);
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        RequestProcessor.processActivity(activity);
                    }
                });
                thread.setName(activity.getName() + "ActivityProcessingThread");
                thread.start();
                threads.add(thread);
            }
            RequestProcessor.processActivity((Activity)this.mEndPoints.get(0));
            try {
                Iterator i = threads.iterator();
                while (i.hasNext()) {
                    ((Thread)i.next()).join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void processActivity(Activity activity) {
        try {
            while (activity.getStatus().isUnfinished()) {
                activity.process();
            }
        }
        catch (Throwable e) {
            activity.setError(new ActivityExecutionException(activity.getName(), e));
        }
    }
}

