/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.util.Observable;
import java.util.Observer;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.common.UniqueName;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.msgs.MessageID;
import uk.org.ogsadai.engine.Status;

class ObserverActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(ObserverActivity.class);
    private boolean mWaiting = true;

    ObserverActivity(final Activity activity) {
        super(UniqueName.getInstance().getName());
        activity.getObservableStatus().addObserver(new Observer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update(Observable observableStatus, Object status) {
                if (((Status)status).isFinished()) {
                    ObserverActivity observerActivity = ObserverActivity.this;
                    synchronized (observerActivity) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info(MessageID.MSG_ACTIVITY_FINISHED, new Object[]{activity.getName(), activity.getClass().getName()});
                        }
                        ObserverActivity.this.mWaiting = false;
                        ObserverActivity.this.notify();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBlock() {
        ObserverActivity observerActivity = this;
        synchronized (observerActivity) {
            while (this.mWaiting) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.setCompleted();
    }
}

