/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.common.DocumentValidationException;
import uk.org.ogsadai.common.DocumentValidator;
import uk.org.ogsadai.common.NetUtilities;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.exception.DAIURLContentException;

public class ConfigurableActivitiesDocumentValidator
extends DocumentValidator {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(ConfigurableActivitiesDocumentValidator.class);

    protected void performValidation(Document document) throws DocumentValidationException {
        NodeList activityMaps = document.getDocumentElement().getElementsByTagName("activityMap");
        for (int i = 0; i < activityMaps.getLength(); ++i) {
            Element activityMap = (Element)activityMaps.item(i);
            String base = activityMap.hasAttribute("configBase") ? activityMap.getAttribute("configBase") : "";
            NodeList activities = activityMap.getElementsByTagName("activity");
            for (int j = 0; j < activities.getLength(); ++j) {
                Element activity = (Element)activities.item(j);
                if (!activity.hasAttribute("config")) continue;
                String name = activity.getAttribute("name");
                String path = base + activity.getAttribute("config");
                this.validateFile(name, path);
            }
        }
    }

    private void validateFile(String name, String path) throws DocumentValidationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating configuration file for activity named \"" + name + "\" at location: " + path);
        }
        try {
            NetUtilities.readToDocument(path, false);
        }
        catch (XMLParseException e) {
            DAIURLContentException fileContentError = new DAIURLContentException(path, e);
            throw new DocumentValidationException(fileContentError);
        }
        catch (DAIException e) {
            throw new DocumentValidationException(e);
        }
    }
}

