/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.PipeAccessException;
import uk.org.ogsadai.engine.Pipe;
import uk.org.ogsadai.engine.ProcessingStatus;

class CallThroughExternalPipe
implements Pipe {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private final Activity mActivity;
    private final List mBuffer = new Vector();
    private boolean mClosed = false;
    private ProcessingStatus mStatus;

    public CallThroughExternalPipe(Activity activity, ProcessingStatus status) {
        this.mActivity = activity;
        this.mStatus = status;
    }

    public boolean hasNext() {
        if (this.mStatus.isInitialising()) {
            throw new PipeAccessException(this.mStatus);
        }
        if (this.mBuffer.size() == 0 && !this.mClosed) {
            this.process();
        }
        return this.mBuffer.size() > 0;
    }

    public Object next() {
        if (this.hasNext()) {
            return this.mBuffer.remove(0);
        }
        throw new NoSuchElementException("There are no more blocks.");
    }

    public void put(Object block) {
        if (block == null) {
            throw new IllegalArgumentException("block must not be null");
        }
        if (this.mClosed) {
            throw new IllegalStateException("Pipe has been closed");
        }
        this.mBuffer.add(block);
        block = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        Activity activity = this.mActivity;
        synchronized (activity) {
            try {
                while (this.mBuffer.size() < 1 && this.mActivity.getStatus().isUnfinished()) {
                    this.mActivity.process();
                }
            }
            catch (Throwable e) {
                this.mActivity.setError(new ActivityExecutionException(this.mActivity.getName(), e));
            }
        }
    }

    public void close() {
        this.mClosed = true;
    }

    public boolean isOpen() {
        return !this.mClosed;
    }
}

