/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import org.w3c.dom.Document;
import uk.org.ogsadai.activity.ActivityTypesCreationException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.service.resource.config.ActivityConfig;

public class ActivityTypesDocumentCreator {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(ActivityTypesDocumentCreator.class);
    private final ActivityConfig[] mActivityConfigs;

    public ActivityTypesDocumentCreator(ActivityConfig[] activityConfigs) {
        this.mActivityConfigs = activityConfigs;
    }

    public Object create() throws ActivityTypesCreationException {
        return this.buildDocument(this.mActivityConfigs);
    }

    private Document buildDocument(ActivityConfig[] activityConfigs) throws ActivityTypesCreationException {
        StringBuffer docString = new StringBuffer();
        docString.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        docString.append("<supportedActivities ");
        docString.append("xmlns=\"http://ogsadai.org.uk/namespaces/2005/10/types\">\n");
        for (int i = 0; i < activityConfigs.length; ++i) {
            ActivityConfig config = activityConfigs[i];
            String name = config.getName();
            docString.append("<activity name=\"");
            docString.append(name);
            docString.append("\">\n");
            String description = config.getDescription();
            if (description != null) {
                docString.append("<description>");
                docString.append(description);
                docString.append("</description>\n");
            }
            docString.append("</activity>\n");
        }
        docString.append("</supportedActivities>");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supported activities document: ");
            LOG.debug(docString.toString());
            LOG.debug("About to parse to DOM Document");
        }
        try {
            Document document = XMLUtilities.xmlStringToDOM(docString.toString(), false);
            return document;
        }
        catch (Exception e) {
            throw new ActivityTypesCreationException(e);
        }
    }
}

