/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import org.w3c.dom.Document;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityFactory;
import uk.org.ogsadai.activity.ActivityRequest;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.common.DocumentValidationException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.engine.Request;
import uk.org.ogsadai.engine.RequestContext;
import uk.org.ogsadai.engine.RequestCreationException;
import uk.org.ogsadai.engine.RequestExecutionException;
import uk.org.ogsadai.engine.RequestFactory;
import uk.org.ogsadai.engine.RequestSpecificationException;
import uk.org.ogsadai.engine.controlflow.RequestComponent;
import uk.org.ogsadai.engine.controlflow.RequestComponentFactory;
import uk.org.ogsadai.engine.controlflow.RequestComponentFactoryImpl;
import uk.org.ogsadai.service.authorization.AccessAuthorizer;
import uk.org.ogsadai.service.authorization.ActivityAccessAuthorizationException;
import uk.org.ogsadai.sessions.SessionStrategy;
import uk.org.ogsadai.sessions.SessionStrategyFactory;
import uk.org.ogsadai.sessions.impl.SessionStrategyFactoryImpl;

public class ActivityRequestFactory
implements RequestFactory {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002-2006.";
    private static final DAILogger LOG = DAILogger.getLogger(ActivityRequestFactory.class);
    private final ActivityFactory mActivityFactory;
    private RequestComponentFactory mComponentFactory = new RequestComponentFactoryImpl();
    private SessionStrategyFactory mSessionStrategyFactory = new SessionStrategyFactoryImpl();
    private final AccessAuthorizer mAuthority;

    public ActivityRequestFactory(ActivityFactory activityFactory, AccessAuthorizer authority) {
        if (activityFactory == null) {
            throw new IllegalArgumentException("activityFactory must not be null");
        }
        this.mActivityFactory = activityFactory;
        this.mAuthority = authority;
    }

    public Request createRequest(Document document, RequestContext context) throws RequestSpecificationException, RequestExecutionException, ActivityAccessAuthorizationException {
        if (LOG.isDebugEnabled()) {
            String message = "Creating an ActivityRequest from the following perform document:\n" + XMLUtilities.xmlDOMToString(document);
            LOG.debug(message);
        }
        try {
            Activity[] activities = this.createActivities(document);
            this.authorizeActivities(activities, context);
            RequestComponent composite = this.mComponentFactory.createRequestComponent(activities, document);
            SessionStrategy strategy = this.mSessionStrategyFactory.createSessionStrategy(document);
            ActivityRequest request = new ActivityRequest(composite, strategy);
            return request;
        }
        catch (RequestCreationException e) {
            throw new RequestExecutionException(e);
        }
        catch (RequestSpecificationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RequestExecutionException(e);
        }
    }

    private Activity[] createActivities(Document requestDocument) throws RequestSpecificationException, RequestCreationException {
        try {
            return this.mActivityFactory.createActivities(requestDocument);
        }
        catch (DocumentValidationException e) {
            throw new RequestSpecificationException(e);
        }
        catch (ActivitySpecificationException e) {
            throw new RequestSpecificationException(e);
        }
        catch (ActivityCreationException e) {
            throw new RequestCreationException(e);
        }
    }

    private void authorizeActivities(Activity[] activities, RequestContext context) throws ActivityAccessAuthorizationException {
        int numActivities = activities.length;
        for (int i = 0; i < numActivities; ++i) {
            if (this.mAuthority.authorizeActivity(context.getResourceID(), activities[i], context.getSecurityContext())) continue;
            throw new ActivityAccessAuthorizationException(activities[i].getActivityName(), context.getResourceID(), context.getSecurityContext() != null ? context.getSecurityContext().getDN() : "Unknown");
        }
    }

    void setRequestComponentFactory(RequestComponentFactory factory) {
        this.mComponentFactory = factory;
    }

    void setSessionStrategyFactory(SessionStrategyFactory factory) {
        this.mSessionStrategyFactory = factory;
    }
}

