/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.util.Timer;
import java.util.TimerTask;
import uk.org.ogsadai.activity.ActivityContext;
import uk.org.ogsadai.activity.ActivityException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.engine.EngineConfiguration;
import uk.org.ogsadai.engine.ProcessingStatus;
import uk.org.ogsadai.engine.ProcessingStatusObserver;
import uk.org.ogsadai.engine.Request;
import uk.org.ogsadai.engine.RequestContext;
import uk.org.ogsadai.engine.RequestExecutionException;
import uk.org.ogsadai.engine.RequestSpecificationException;
import uk.org.ogsadai.engine.ResponseBuilder;
import uk.org.ogsadai.engine.controlflow.RequestComponent;
import uk.org.ogsadai.sessions.Session;
import uk.org.ogsadai.sessions.SessionParticipant;
import uk.org.ogsadai.sessions.SessionStrategy;

public class ActivityRequest
implements Request,
SessionParticipant {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(ActivityRequest.class);
    private RequestComponent mRequest;
    private Thread mThread;
    private final ProcessingStatus mStatus;
    private SessionStrategy mStrategy;
    private Session mSession;
    private RequestContext mRequestContext;
    private ActivityContext mActivityContext;
    private ResponseBuilder mResponseBuilder;
    private EngineConfiguration mConfiguration;
    private ProcessingStatusObserver mObserver;
    private Timer mTimeOutTimer;

    public ActivityRequest(RequestComponent composite, SessionStrategy strategy) {
        this.mRequest = composite;
        this.mStrategy = strategy;
        this.mStatus = new ProcessingStatus(this);
        this.mObserver = new ProcessingStatusObserver();
        this.mStatus.addObserver(this.mObserver);
    }

    public ProcessingStatus getStatus() {
        return this.mStatus;
    }

    public synchronized void initialise(EngineConfiguration config, RequestContext context, ResponseBuilder builder) throws IllegalStateException, RequestSpecificationException, RequestExecutionException {
        this.mStatus.setInitialising();
        this.mRequestContext = context;
        this.mConfiguration = config;
        this.mResponseBuilder = builder;
        this.mResponseBuilder.buildSessionDetails(this.mSession);
        this.mTimeOutTimer = this.mConfiguration.getRequestProcessingTimeout() > 0L ? new Timer() : null;
        try {
            this.mActivityContext = new ActivityContext(config, context);
            this.mRequest.initialise(this.mActivityContext, this.mSession, this.mResponseBuilder);
        }
        catch (RequestSpecificationException e) {
            this.reportError(e);
            throw e;
        }
        catch (RequestExecutionException e) {
            this.reportError(e);
            throw e;
        }
    }

    public synchronized void process() throws IllegalStateException {
        this.mStatus.setProcessing();
        if (this.mTimeOutTimer != null) {
            this.mTimeOutTimer.schedule((TimerTask)new TimeOutTask(), this.mConfiguration.getRequestProcessingTimeout());
        }
        this.processAsynchronously();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        if (this.mStatus.isStopped()) {
            return;
        }
        this.endProcessing();
        ProcessingStatus processingStatus = this.mStatus;
        synchronized (processingStatus) {
            if (!this.mStatus.isStopped()) {
                this.mStatus.setTerminated();
            }
        }
    }

    private void endProcessing() {
        this.mRequest.terminate();
        if (this.mThread != null) {
            try {
                this.mThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void waitForResponse() {
        if (this.mRequest.generatesResultData() || this.mRequest.children().size() == 0) {
            this.mObserver.waitForCompletion();
        }
        if (this.mStatus.isError()) {
            Throwable cause = this.mRequestContext.getCauseOfError();
            String name = "?";
            if (cause instanceof ActivityException) {
                name = ((ActivityException)((Object)cause)).getActivityName();
            }
            this.mResponseBuilder.buildRequestError(name);
        } else {
            this.mResponseBuilder.buildRequestStatus(this.mStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reportError(Exception cause) {
        ProcessingStatus processingStatus = this.mStatus;
        synchronized (processingStatus) {
            if (!this.mStatus.isStopped()) {
                this.mStatus.setError();
            }
        }
    }

    private void processAsynchronously() {
        this.mThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Starting processing thread for request: " + ActivityRequest.this.mRequest);
                    }
                    ActivityRequest.this.mRequest.process(ActivityRequest.this.mActivityContext, ActivityRequest.this.mResponseBuilder);
                    ProcessingStatus processingStatus = ActivityRequest.this.mStatus;
                    synchronized (processingStatus) {
                        if (ActivityRequest.this.mStatus.isProcessing()) {
                            ActivityRequest.this.mStatus.setCompleted();
                        }
                    }
                }
                catch (RequestSpecificationException e) {
                    ActivityRequest.this.reportError(e);
                }
                catch (RequestExecutionException e) {
                    ActivityRequest.this.reportError(e);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Finished processing thread");
                }
            }
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting request processing thread.");
        }
        this.mThread.start();
    }

    public SessionStrategy getSessionStrategy() {
        return this.mStrategy;
    }

    public void setSession(Session session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Settion session for request: " + session.getID());
        }
        this.mSession = session;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session set.");
        }
    }

    public Session getSession() {
        return this.mSession;
    }

    RequestComponent getRequestComposite() {
        return this.mRequest;
    }

    private class TimeOutTask
    extends TimerTask {
        private TimeOutTask() {
        }

        public void run() {
            ActivityRequest.this.mTimeOutTimer.cancel();
            if (!ActivityRequest.this.mStatus.isProcessing()) {
                return;
            }
            ActivityRequest.this.endProcessing();
            ActivityRequest.this.mStatus.setTimedOut();
        }
    }
}

