/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.DuplicateActivityPropertyKeyException;
import uk.org.ogsadai.common.DocumentValidationException;
import uk.org.ogsadai.common.DocumentValidator;

public class ActivityPropertyDocumentValidator
extends DocumentValidator {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";

    protected void performValidation(Document document) throws DocumentValidationException {
        NodeList activityMaps = document.getDocumentElement().getElementsByTagName("activityMap");
        for (int i = 0; i < activityMaps.getLength(); ++i) {
            Element activityMap = (Element)activityMaps.item(i);
            NodeList activities = activityMap.getElementsByTagName("activity");
            for (int j = 0; j < activities.getLength(); ++j) {
                Element activity = (Element)activities.item(j);
                NodeList properties = activity.getElementsByTagName("property");
                if (properties.getLength() <= 0) continue;
                String name = activity.getAttribute("name");
                this.validatePropertyElements(name, properties);
            }
        }
    }

    private void validatePropertyElements(String name, NodeList properties) throws DocumentValidationException {
        ArrayList<String> collection = new ArrayList<String>();
        for (int i = 0; i < properties.getLength(); ++i) {
            Element property = (Element)properties.item(i);
            String key = property.getAttribute("key");
            if (collection.contains(key)) {
                throw new DocumentValidationException(new DuplicateActivityPropertyKeyException(key));
            }
            collection.add(key);
        }
    }
}

