/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityContext;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.DuplicatePipeException;
import uk.org.ogsadai.activity.ObserverActivity;
import uk.org.ogsadai.activity.RequestProcessor;
import uk.org.ogsadai.activity.ResultActivity;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.msgs.MessageID;
import uk.org.ogsadai.engine.RequestExecutionException;
import uk.org.ogsadai.engine.RequestSpecificationException;
import uk.org.ogsadai.engine.ResponseBuilder;
import uk.org.ogsadai.engine.Status;
import uk.org.ogsadai.engine.controlflow.RequestComponent;
import uk.org.ogsadai.sessions.Session;
import uk.org.ogsadai.sessions.SessionRequestException;

public class ActivityPipelineRequestComponent
implements RequestComponent {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(ActivityPipelineRequestComponent.class);
    private final List mActivities = new ArrayList();
    private ResultActivity[] mResultActivities;
    private ObserverActivity[] mObserverActivities;
    private ActivityContext mContext;
    private ResponseBuilder mResponseBuilder;

    public ActivityPipelineRequestComponent() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating a new ActivityPipelineRequestComponent");
        }
    }

    public void initialise(ActivityContext context, Session session, ResponseBuilder responseBuilder) throws RequestSpecificationException, RequestExecutionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting to initialise pipeline of activities.");
        }
        this.mContext = context;
        this.mResponseBuilder = responseBuilder;
        this.prepareActivities(context, session);
        this.createInternalActivities();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished initialising pipeline of activities.");
        }
    }

    public void process(ActivityContext context, ResponseBuilder responseBuilder) throws RequestSpecificationException, RequestExecutionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting to process pipeline of activities.");
        }
        List endPoints = this.getEndPointActivities();
        RequestProcessor processor = new RequestProcessor(endPoints);
        if (this.mActivities.size() > 0) {
            processor.process();
            this.checkForErrors();
            this.buildResponse();
            if (this.mContext.hasError()) {
                Throwable cause = this.mContext.getCauseOfError();
                if (cause instanceof ActivitySpecificationException) {
                    throw new RequestSpecificationException(cause);
                }
                throw new RequestExecutionException(cause);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished processing pipeline of activities.");
        }
    }

    private List getEndPointActivities() {
        ArrayList<Activity> endPoints = new ArrayList<Activity>();
        for (int i = 0; i < this.mActivities.size(); ++i) {
            Activity activity = (Activity)this.mActivities.get(i);
            if (activity.getOutputs().length != 0 || activity.getExternalOutputs().length != 0) continue;
            endPoints.add(activity);
        }
        endPoints.addAll(Arrays.asList(this.mResultActivities));
        endPoints.addAll(Arrays.asList(this.mObserverActivities));
        return endPoints;
    }

    private void prepareActivities(ActivityContext activityContext, Session session) throws RequestSpecificationException, RequestExecutionException {
        Activity activity;
        int i;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring the context for each activity");
        }
        for (i = 0; i < this.mActivities.size(); ++i) {
            activity = (Activity)this.mActivities.get(i);
            try {
                activity.configureContext(activityContext, session);
                continue;
            }
            catch (DuplicatePipeException e) {
                throw new RequestSpecificationException(e);
            }
            catch (SessionRequestException e) {
                throw new RequestSpecificationException(e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initialising each activity");
        }
        for (i = 0; i < this.mActivities.size(); ++i) {
            activity = (Activity)this.mActivities.get(i);
            try {
                activity.initialise();
                if (!LOG.isInfoEnabled()) continue;
                LOG.info(MessageID.MSG_ACTIVITY_INITIALISED, new Object[]{activity.getName(), activity.getClass().getName(), session.getID()});
                continue;
            }
            catch (RuntimeException e) {
                ActivityExecutionException cause = new ActivityExecutionException(activity.getName(), e);
                throw new RequestExecutionException(cause);
            }
            catch (ActivityExecutionException e) {
                throw new RequestExecutionException(e);
            }
            catch (ActivitySpecificationException e) {
                throw new RequestSpecificationException(e);
            }
        }
    }

    private void createInternalActivities() throws RequestExecutionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructing internal activities");
        }
        String[] outputs = this.getUnconnectedOutputs();
        this.mResultActivities = new ResultActivity[outputs.length];
        try {
            for (int i = 0; i < outputs.length; ++i) {
                this.mResultActivities[i] = new ResultActivity(outputs[i], this.mContext.getInput(outputs[i]));
            }
        }
        catch (ActivityStreamNotFoundException e) {
            throw new RequestExecutionException(e);
        }
        List externalActivities = this.getExternalOutputActivities();
        this.mObserverActivities = new ObserverActivity[externalActivities.size()];
        for (int i = 0; i < externalActivities.size(); ++i) {
            Activity activity = (Activity)this.mActivities.get(i);
            this.mObserverActivities[i] = new ObserverActivity(activity);
        }
    }

    private final String[] getUnconnectedOutputs() {
        ArrayList<String> inputs = new ArrayList<String>();
        ArrayList<String> outputs = new ArrayList<String>();
        for (int i = 0; i < this.mActivities.size(); ++i) {
            Activity activity = (Activity)this.mActivities.get(i);
            inputs.addAll(Arrays.asList(activity.getInputs()));
            outputs.addAll(Arrays.asList(activity.getOutputs()));
        }
        outputs.removeAll(inputs);
        return outputs.toArray(new String[outputs.size()]);
    }

    private final List getExternalOutputActivities() {
        ArrayList<Activity> externalActivities = new ArrayList<Activity>();
        for (int i = 0; i < this.mActivities.size(); ++i) {
            Activity activity = (Activity)this.mActivities.get(i);
            if (activity.getExternalOutputs().length <= 0) continue;
            externalActivities.add(activity);
        }
        return externalActivities;
    }

    private void checkForErrors() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("checkForErrors: start");
        }
        if (this.mContext.hasError()) {
            Activity[] activities = this.getAllActivities();
            if (LOG.isDebugEnabled()) {
                LOG.debug("there was an error in one of the activities...");
            }
            for (int i = 0; i < activities.length; ++i) {
                if (activities[i].getStatus() == Status.ERROR) continue;
                activities[i].terminate();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("checkForErrors: stop");
        }
    }

    private void buildResponse() {
        Throwable cause;
        Status status;
        Activity activity;
        Iterator i = this.mActivities.iterator();
        while (i.hasNext()) {
            activity = (Activity)i.next();
            status = activity.getStatus();
            if (status == Status.ERROR) {
                cause = activity.getCause();
                this.mResponseBuilder.buildError(activity.getName(), cause);
                continue;
            }
            this.mResponseBuilder.buildResult(activity.getName(), status, null);
        }
        for (int i2 = 0; i2 < this.mResultActivities.length; ++i2) {
            activity = this.mResultActivities[i2];
            status = activity.getStatus();
            if (status == Status.ERROR) {
                cause = activity.getCause();
                this.mResponseBuilder.buildError(activity.getName(), cause);
                continue;
            }
            this.mResponseBuilder.buildResult(activity.getName(), status, ((ResultActivity)activity).getResultData());
        }
    }

    private Activity[] getAllActivities() {
        ArrayList<Activity> list = new ArrayList<Activity>();
        list.addAll(this.mActivities);
        list.addAll(Arrays.asList(this.mResultActivities));
        list.addAll(Arrays.asList(this.mObserverActivities));
        Activity[] activities = new Activity[this.mActivities.size() + this.mResultActivities.length + this.mObserverActivities.length];
        return list.toArray(activities);
    }

    public void add(RequestComponent child) {
    }

    public List children() {
        return Collections.EMPTY_LIST;
    }

    public void addActivity(Activity activity) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding activity to pipeline: " + activity.getName());
        }
        this.mActivities.add(activity);
    }

    public boolean containsActivity(String activityName) {
        boolean found = false;
        Iterator i = this.mActivities.iterator();
        while (i.hasNext() && !found) {
            Activity activity = (Activity)i.next();
            if (!activityName.equals(activity.getName())) continue;
            found = true;
        }
        return found;
    }

    public boolean generatesResultData() {
        return this.mResultActivities.length > 0;
    }

    public void terminate() {
        Iterator i = this.mActivities.iterator();
        while (i.hasNext()) {
            Activity activity = (Activity)i.next();
            activity.terminate();
        }
    }
}

