/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityCreator;
import uk.org.ogsadai.activity.ActivityFactory;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.ActivityTypesDocumentCreator;
import uk.org.ogsadai.activity.SchemaDocumentValidator;
import uk.org.ogsadai.activity.UnknownActivityDocumentValidator;
import uk.org.ogsadai.common.DocumentValidationException;
import uk.org.ogsadai.common.DocumentValidator;
import uk.org.ogsadai.common.SecurityContext;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.DynamicProperty;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.properties.PropertyCallback;
import uk.org.ogsadai.common.properties.PropertyValueException;
import uk.org.ogsadai.common.xml.XMLSchemaUtilities;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.DataResourcePropertyNames;
import uk.org.ogsadai.service.resource.config.ActivitiesConfig;
import uk.org.ogsadai.service.resource.config.ActivityConfig;

public class ActivityFactoryImpl
implements ActivityFactory,
PropertyCallback {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(ActivityFactoryImpl.class);
    private final Map mActivityMap;
    private final ActivityTypesDocumentCreator mActivityTypes;
    private final DocumentValidator mValidator;
    private Document mSchema;

    public ActivityFactoryImpl(ActivitiesConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        this.mActivityMap = this.createActivityMap(config.getActivityConfigs());
        this.mSchema = this.buildPerformDocumentSchema(config.getBasePerformDocumentSchema(), config.getActivityConfigs());
        this.mValidator = new UnknownActivityDocumentValidator(this.mActivityMap.keySet());
        this.mValidator.setSuccessor(new SchemaDocumentValidator(this.mSchema));
        this.mActivityTypes = new ActivityTypesDocumentCreator(config.getActivityConfigs());
    }

    public Activity[] createActivities(Document document) throws DocumentValidationException, ActivitySpecificationException, ActivityCreationException {
        if (document == null) {
            throw new IllegalArgumentException("document must not be null");
        }
        this.mValidator.validate(document);
        ArrayList list = new ArrayList();
        Element root = document.getDocumentElement();
        this.parseChildren(root, list);
        return list.toArray(new Activity[list.size()]);
    }

    private void parseChildren(Node root, List list) throws DocumentValidationException, ActivitySpecificationException, ActivityCreationException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String name = element.getLocalName();
            if (name.equals("sequence") || name.equals("flow")) {
                this.parseChildren(element, list);
                continue;
            }
            if (name.equals("documentation") || name.equals("session")) continue;
            Activity activity = this.createActivity(element);
            list.add(activity);
        }
    }

    private Activity createActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        if (element == null) {
            throw new IllegalArgumentException("element must not be null");
        }
        Activity activity = null;
        String activityName = element.getLocalName().intern();
        ActivityCreator creator = (ActivityCreator)this.mActivityMap.get(activityName);
        activity = creator.createActivity(element);
        activity.setActivityName(activityName);
        return activity;
    }

    private Map createActivityMap(ActivityConfig[] activityConfigs) {
        HashMap<String, ActivityCreator> result = new HashMap<String, ActivityCreator>();
        int numActivities = activityConfigs.length;
        for (int i = 0; i < numActivities; ++i) {
            ActivityCreator creator = new ActivityCreator(activityConfigs[i]);
            result.put(creator.getName(), creator);
        }
        return result;
    }

    private Document buildPerformDocumentSchema(Document baseSchema, ActivityConfig[] activityConfigs) {
        Document schema = (Document)baseSchema.cloneNode(true);
        int numActivities = activityConfigs.length;
        for (int i = 0; i < numActivities; ++i) {
            Document activitySchema = activityConfigs[i].getSchema();
            Document clonedSchema = (Document)activitySchema.cloneNode(true);
            XMLSchemaUtilities.removeAllIncludes(clonedSchema);
            XMLSchemaUtilities.merge(schema, clonedSchema);
        }
        if (LOG.isDebugEnabled()) {
            String s = XMLUtilities.xmlDOMToString(schema);
            LOG.debug("Perform document schema: " + s);
        }
        return schema;
    }

    public Property[] getProperties() {
        DynamicProperty types = new DynamicProperty();
        types.setName(DataResourcePropertyNames.ACTIVITY_TYPES);
        types.setCallback(this);
        DynamicProperty schema = new DynamicProperty();
        schema.setName(DataResourcePropertyNames.PERFORM_DOCUMENT_SCHEMA);
        schema.setCallback(this);
        return new Property[]{schema, types};
    }

    public Object getValue(QName name) throws PropertyValueException {
        Object value = null;
        if (name.equals(DataResourcePropertyNames.ACTIVITY_TYPES)) {
            try {
                value = this.mActivityTypes.create();
            }
            catch (Exception e) {
                throw new PropertyValueException(name, (Throwable)e);
            }
        } else if (name.equals(DataResourcePropertyNames.PERFORM_DOCUMENT_SCHEMA)) {
            value = this.mSchema;
        }
        return value;
    }

    public void setValue(QName name, Object value) {
    }

    public void setSecurityContext(SecurityContext sec) {
    }
}

