/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityConfiguration;
import uk.org.ogsadai.activity.ActivityConfigurationCreator;
import uk.org.ogsadai.activity.ActivityConfigurationException;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.DAIClassCreateException;
import uk.org.ogsadai.exception.DAIClassMissingInterfaceException;
import uk.org.ogsadai.exception.DAIClassNotFoundException;
import uk.org.ogsadai.service.resource.config.ActivityConfig;

class ActivityCreator {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(ActivityCreator.class);
    private final String mName;
    private final String mClass;
    private final Document mSchemaDoc;
    private final Document mConfigDoc;
    private ActivityConfiguration mConfiguration;
    private final Properties mProperties;

    ActivityCreator(ActivityConfig activityConfig) {
        if (activityConfig == null) {
            throw new IllegalArgumentException("activityConfig must not be null");
        }
        this.mName = activityConfig.getName();
        this.mClass = activityConfig.getImplementationClassName();
        this.mSchemaDoc = activityConfig.getSchema();
        this.mProperties = activityConfig.getProperties();
        this.mConfigDoc = activityConfig.getConfigDocument();
        if (LOG.isDebugEnabled()) {
            LOG.debug("New instance constructed with name = " + this.mName + ", implementation = " + this.mClass);
        }
    }

    public Activity createActivity(Element element) throws ActivitySpecificationException, ActivityCreationException {
        Activity activity = null;
        try {
            Class<?> activityClass = Class.forName(this.mClass);
            Constructor<?> constructor = activityClass.getConstructor(Element.class);
            activity = (Activity)constructor.newInstance(element);
            if (this.mProperties != null) {
                activity.setProperties(this.mProperties);
            }
            if (this.mConfigDoc != null) {
                this.initialiseActivityConfiguration(activity, this.mConfigDoc);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ActivityCreationException(this.mName, new DAIClassNotFoundException(this.mClass));
        }
        catch (InstantiationException e) {
            throw new ActivityCreationException(this.mName, new DAIClassCreateException(this.mClass, e));
        }
        catch (IllegalAccessException e) {
            throw new ActivityCreationException(this.mName, new DAIClassCreateException(this.mClass, e));
        }
        catch (ClassCastException e) {
            throw new ActivityCreationException(this.mName, new DAIClassMissingInterfaceException(this.mClass, Activity.class.getName()));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof ActivitySpecificationException) {
                throw (ActivitySpecificationException)cause;
            }
            if (cause instanceof ActivityCreationException) {
                throw (ActivityCreationException)cause;
            }
            throw new ActivityCreationException(this.mName, e);
        }
        catch (ActivityConfigurationException e) {
            throw new ActivityCreationException(this.mName, e);
        }
        catch (Exception e) {
            throw new ActivityCreationException(this.mName, e);
        }
        return activity;
    }

    private void initialiseActivityConfiguration(Activity activity, Document configurationDoc) throws ActivityConfigurationException {
        if (this.mConfiguration == null) {
            ActivityConfigurationCreator creator = (ActivityConfigurationCreator)((Object)activity);
            this.mConfiguration = creator.createActivityConfiguration();
            this.mConfiguration.initialise(configurationDoc);
        }
        activity.setActivityConfiguration(this.mConfiguration);
    }

    public final String getName() {
        return this.mName;
    }

    public Document getSchema() {
        return this.mSchemaDoc;
    }
}

