/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.util.HashMap;
import java.util.Map;
import uk.org.ogsadai.activity.ActivityRequest;
import uk.org.ogsadai.activity.ActivityStreamNotFoundException;
import uk.org.ogsadai.activity.DuplicatePipeException;
import uk.org.ogsadai.client.toolkit.soap.AttachmentManager;
import uk.org.ogsadai.common.BlockReader;
import uk.org.ogsadai.common.BlockWriter;
import uk.org.ogsadai.common.SecurityContext;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.engine.EngineConfiguration;
import uk.org.ogsadai.engine.Pipe;
import uk.org.ogsadai.engine.RequestContext;
import uk.org.ogsadai.service.authorization.AccessAuthorizer;
import uk.org.ogsadai.service.resource.factory.DataServiceResourceFactory;

public class ActivityContext {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(ActivityContext.class);
    private final RequestContext mContext;
    private final Map mInternalPipes = new HashMap();
    private final EngineConfiguration mEngineConfiguration;

    public ActivityContext(EngineConfiguration engineConfiguration, RequestContext context) {
        this.mContext = context;
        this.mEngineConfiguration = engineConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addPipe(String name, Pipe pipe) throws DuplicatePipeException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding internal pipe: " + name + " : " + pipe);
        }
        Map map = this.mInternalPipes;
        synchronized (map) {
            if (this.mInternalPipes.containsKey(name)) {
                throw new DuplicatePipeException(name);
            }
            this.mInternalPipes.put(name, pipe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean hasPipe(String name) {
        Map map = this.mInternalPipes;
        synchronized (map) {
            return this.mInternalPipes.containsKey(name);
        }
    }

    public final DataResourceAccessor getDataResourceAccessor() {
        return this.mEngineConfiguration.getDataResourceAccessor();
    }

    public final DataServiceResourceFactory getDataResourceFactory() {
        return this.mContext.getDataServiceResourceFactory();
    }

    public final BlockReader getInput(String name) throws ActivityStreamNotFoundException {
        Map map = this.mInternalPipes;
        synchronized (map) {
            if (this.mInternalPipes.containsKey(name)) {
                return (BlockReader)this.mInternalPipes.get(name);
            }
            throw new ActivityStreamNotFoundException(name);
        }
    }

    public final BlockWriter getOutput(String name) throws ActivityStreamNotFoundException {
        Map map = this.mInternalPipes;
        synchronized (map) {
            if (this.mInternalPipes.containsKey(name)) {
                return (BlockWriter)this.mInternalPipes.get(name);
            }
            throw new ActivityStreamNotFoundException(name);
        }
    }

    public final SecurityContext getSecurityContext() {
        return this.mContext.getSecurityContext();
    }

    public String getURL() {
        return this.mContext.getURL();
    }

    public String getResourceID() {
        return this.mContext.getResourceID();
    }

    public AttachmentManager getAttachmentManager() {
        return this.mContext.getAttachmentManager();
    }

    public AccessAuthorizer getAuthorizer() {
        return this.mContext.getAuthorizer();
    }

    final synchronized void setError(Throwable cause) {
        this.mContext.setError(cause);
    }

    final boolean hasError() {
        return this.mContext.hasError();
    }

    final Throwable getCauseOfError() {
        return this.mContext.getCauseOfError();
    }

    final ActivityRequest getActivityRequest() {
        return (ActivityRequest)this.mContext.getRequest();
    }
}

