/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.Activity;
import uk.org.ogsadai.activity.ActivityConfigurationCreator;
import uk.org.ogsadai.activity.InvalidActivityClassException;
import uk.org.ogsadai.common.DocumentValidationException;
import uk.org.ogsadai.common.DocumentValidator;
import uk.org.ogsadai.exception.DAIClassNotFoundException;

public class ActivityClassDocumentValidator
extends DocumentValidator {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";

    protected void performValidation(Document document) throws DocumentValidationException {
        NodeList activityMaps = document.getDocumentElement().getElementsByTagName("activityMap");
        for (int i = 0; i < activityMaps.getLength(); ++i) {
            Element activityMap = (Element)activityMaps.item(i);
            NodeList activities = activityMap.getElementsByTagName("activity");
            for (int j = 0; j < activities.getLength(); ++j) {
                Element activity = (Element)activities.item(j);
                this.validateImplementation(activity.getAttribute("implementation"), activity.hasAttribute("config"));
            }
        }
    }

    private void validateImplementation(String implementation, boolean usesConfigFile) throws DocumentValidationException {
        try {
            Class<?> activityClass = Class.forName(implementation);
            if (!Activity.class.isAssignableFrom(activityClass)) {
                throw new DocumentValidationException(new InvalidActivityClassException(implementation, Activity.class.getName()));
            }
            if (usesConfigFile && !ActivityConfigurationCreator.class.isAssignableFrom(activityClass)) {
                throw new DocumentValidationException(new InvalidActivityClassException(implementation, ActivityConfigurationCreator.class.getName()));
            }
        }
        catch (ClassNotFoundException e) {
            throw new DocumentValidationException(new DAIClassNotFoundException(implementation));
        }
    }
}

