/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.w3c.dom.Element;
import uk.org.ogsadai.activity.ActivityConfiguration;
import uk.org.ogsadai.activity.ActivityContext;
import uk.org.ogsadai.activity.ActivityCreationException;
import uk.org.ogsadai.activity.ActivityExecutionException;
import uk.org.ogsadai.activity.ActivityRequest;
import uk.org.ogsadai.activity.ActivitySpecificationException;
import uk.org.ogsadai.activity.CallThroughExternalPipe;
import uk.org.ogsadai.activity.CallThroughPipe;
import uk.org.ogsadai.activity.DuplicatePipeException;
import uk.org.ogsadai.activity.SynchronizedGrowableExternalPipe;
import uk.org.ogsadai.common.MemoryUtilities;
import uk.org.ogsadai.common.OutOfMemoryException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.engine.ObservableStatus;
import uk.org.ogsadai.engine.Pipe;
import uk.org.ogsadai.engine.Status;
import uk.org.ogsadai.sessions.Session;
import uk.org.ogsadai.sessions.SessionRequestException;
import uk.org.ogsadai.sessions.SessionStreamDuplicateException;

public abstract class Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(Activity.class);
    private final String mName;
    private String mActivityName;
    private Properties mProperties;
    private ActivityConfiguration mConfiguration;
    protected String[] mInternalInputs = new String[0];
    protected String[] mInternalOutputs = new String[0];
    protected String[] mExternalInputs = new String[0];
    protected String[] mExternalOutputs = new String[0];
    protected ActivityContext mContext;
    private Session mSession;
    private ActivityRequest mRequest;
    private final ObservableStatus mStatus;
    private Throwable mCause;

    public Activity(Element element) throws ActivityCreationException, ActivitySpecificationException {
        this(element.getAttribute("name"));
    }

    public Activity(String name) {
        this.mName = name;
        this.mStatus = new ObservableStatus(this.mName + "Status", Status.UNSTARTED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructing activity of type " + this.getClass().getName() + " named " + this.mName);
        }
    }

    protected void cleanUp() {
    }

    final void configureContext(ActivityContext context, Session session) throws SessionRequestException, DuplicatePipeException {
        int i;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring activity " + this.getName() + " with context and session.");
        }
        this.mSession = session;
        this.mContext = context;
        for (i = 0; i < this.mInternalOutputs.length; ++i) {
            this.mContext.addPipe(this.mInternalOutputs[i], this.createOutputPipe(i));
        }
        try {
            for (i = 0; i < this.mExternalOutputs.length; ++i) {
                this.mSession.addExternalOutput(this.mExternalOutputs[i], new CallThroughExternalPipe(this, this.mContext.getActivityRequest().getStatus()));
            }
            for (i = 0; i < this.mExternalInputs.length; ++i) {
                this.mSession.addExternalInput(this.mExternalInputs[i], new SynchronizedGrowableExternalPipe(this.mContext.getActivityRequest().getStatus()));
            }
        }
        catch (SessionStreamDuplicateException e) {
            throw new SessionRequestException(session.getID(), e);
        }
    }

    protected Pipe createOutputPipe(int i) {
        return new CallThroughPipe(this);
    }

    final String[] getInputs() {
        return this.mInternalInputs;
    }

    final String[] getOutputs() {
        return this.mInternalOutputs;
    }

    final String[] getAllOutputs() {
        ArrayList<String> outputs = new ArrayList<String>();
        outputs.addAll(Arrays.asList(this.mInternalOutputs));
        outputs.addAll(Arrays.asList(this.mExternalOutputs));
        return outputs.toArray(new String[outputs.size()]);
    }

    final String[] getExternalInputs() {
        return this.mExternalInputs;
    }

    final String[] getExternalOutputs() {
        return this.mExternalOutputs;
    }

    public final String getName() {
        return this.mName;
    }

    public final Status getStatus() {
        return this.mStatus.getStatus();
    }

    protected final ObservableStatus getObservableStatus() {
        return this.mStatus;
    }

    protected void initialise() throws ActivitySpecificationException, ActivityExecutionException {
    }

    public final void process() {
        if (this.getStatus().isUnstarted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting to process activity: " + this.mName);
            }
            this.mStatus.setStatus(Status.PROCESSING);
            this.processFirst();
        }
        if (this.getStatus().isUnfinished()) {
            try {
                MemoryUtilities.checkMemory(0, LOG);
                this.processBlock();
            }
            catch (OutOfMemoryException e) {
                this.setError(new ActivityExecutionException(this.getName(), e));
            }
        }
    }

    protected void processFirst() {
    }

    protected abstract void processBlock();

    protected final void setCompleted() {
        this.mStatus.setStatus(Status.COMPLETED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Completed processing activity: " + this.mName);
        }
    }

    protected final void setError(Throwable cause) {
        if (this.mContext != null) {
            this.mContext.setError(cause);
        }
        this.mStatus.setStatus(Status.ERROR);
        this.mCause = cause;
        this.cleanUp();
    }

    public final Throwable getCause() {
        return this.mCause;
    }

    final synchronized void terminate() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminating activity: " + this.mName);
        }
        this.mStatus.setStatus(Status.TERMINATED);
        this.cleanUp();
    }

    void setProperties(Properties properties) {
        this.mProperties = properties;
    }

    protected Properties getProperties() {
        return this.mProperties;
    }

    protected boolean hasProperties() {
        return this.mProperties != null;
    }

    void setActivityConfiguration(ActivityConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    protected boolean hasActivityConfiguration() {
        return this.mConfiguration != null;
    }

    protected ActivityConfiguration getActivityConfiguration() {
        return this.mConfiguration;
    }

    public boolean connectsTo(Activity activity) {
        int j;
        int i;
        boolean connected = false;
        for (i = 0; i < this.mInternalInputs.length && !connected; ++i) {
            for (j = 0; j < activity.mInternalOutputs.length && !connected; ++j) {
                if (!this.mInternalInputs[i].equals(activity.mInternalOutputs[j])) continue;
                connected = true;
            }
        }
        for (i = 0; i < this.mInternalOutputs.length && !connected; ++i) {
            for (j = 0; j < activity.mInternalInputs.length && !connected; ++j) {
                if (!this.mInternalOutputs[i].equals(activity.mInternalInputs[j])) continue;
                connected = true;
            }
        }
        return connected;
    }

    protected final Session getSession() {
        if (this.mSession == null) {
            throw new IllegalStateException("session has not yet been set. Should not call this method until initialise() has been called");
        }
        return this.mSession;
    }

    public final void setActivityName(String activityName) {
        this.mActivityName = activityName;
    }

    public final String getActivityName() {
        return this.mActivityName;
    }
}

