/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.integration.jboss;

import com.mysql.jdbc.SQLError;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;

public final class MysqlValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = 3258689922776119348L;
    private Method pingMethod;
    private static final Object[] NO_ARGS_OBJECT_ARRAY = new Object[0];

    public MysqlValidConnectionChecker() {
        try {
            Class<?> mysqlConnection = Thread.currentThread().getContextClassLoader().loadClass("com.mysql.jdbc.Connection");
            this.pingMethod = mysqlConnection.getMethod("ping", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLException isValidConnection(Connection conn) {
        SQLException sQLException;
        if (this.pingMethod != null) {
            try {
                this.pingMethod.invoke((Object)conn, NO_ARGS_OBJECT_ARRAY);
                return null;
            }
            catch (Exception ex) {
                if (!(ex instanceof SQLException)) return SQLError.createSQLException("Ping failed: " + ex.toString());
                return (SQLException)ex;
            }
        }
        Statement pingStatement = null;
        try {
            try {
                pingStatement.executeQuery("SELECT 1").close();
                sQLException = null;
                Object var6_6 = null;
                if (pingStatement == null) return sQLException;
            }
            catch (SQLException sqlEx) {
                SQLException sQLException2 = sqlEx;
                Object var6_7 = null;
                if (pingStatement == null) return sQLException2;
                try {
                    pingStatement.close();
                    return sQLException2;
                }
                catch (SQLException sqlEx2) {
                    // empty catch block
                }
                return sQLException2;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (pingStatement == null) throw throwable;
            try {}
            catch (SQLException sqlEx2) {
                throw throwable;
            }
            pingStatement.close();
            throw throwable;
        }
        try {}
        catch (SQLException sqlEx2) {
            // empty catch block
            return sQLException;
        }
        pingStatement.close();
        return sQLException;
    }
}

