/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.ResourceRef;

public class ResourceFactory
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object instanceof ResourceRef) {
            Reference reference = (Reference)object;
            ObjectFactory objectFactory = null;
            RefAddr refAddr = reference.get("factory");
            if (refAddr != null) {
                String string = refAddr.getContent().toString();
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = null;
                if (classLoader != null) {
                    try {
                        clazz = classLoader.loadClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NamingException("Could not create resource factory, ClassNotFoundException:" + classNotFoundException.getMessage());
                    }
                }
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NamingException("Could not create resource factory, ClassNotFoundException:" + classNotFoundException.getMessage());
                }
                if (clazz != null) {
                    try {
                        objectFactory = (ObjectFactory)clazz.newInstance();
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof NamingException) {
                            throw (NamingException)throwable;
                        }
                        throw new NamingException("Could not create resource factory instance, " + throwable.getMessage());
                    }
                }
            } else if (reference.getClassName().equals("javax.sql.DataSource")) {
                String string = System.getProperty("javax.sql.DataSource.Factory", "org.apache.tomcat.dbcp.dbcp.BasicDataSourceFactory");
                try {
                    objectFactory = (ObjectFactory)Class.forName(string).newInstance();
                }
                catch (Throwable throwable) {}
            } else if (reference.getClassName().equals("javax.mail.Session")) {
                String string = System.getProperty("javax.mail.Session.Factory", "org.apache.naming.factory.MailSessionFactory");
                try {
                    objectFactory = (ObjectFactory)Class.forName(string).newInstance();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (objectFactory != null) {
                return objectFactory.getObjectInstance(object, name, context, hashtable);
            }
            throw new NamingException("Cannot create resource instance");
        }
        return null;
    }
}

